/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.statistics;

import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.jol.info.ClassLayout;
import com.facebook.presto.jdbc.internal.spi.statistics.ConnectorHistogram;
import com.facebook.presto.jdbc.internal.spi.statistics.DoubleRange;
import com.facebook.presto.jdbc.internal.spi.statistics.Estimate;
import java.util.Objects;
import java.util.Optional;

public final class ColumnStatistics {
    private static final long COLUMN_STATISTICS_SIZE = ClassLayout.parseClass(ColumnStatistics.class).instanceSize();
    private static final long OPTION_SIZE = ClassLayout.parseClass(Optional.class).instanceSize();
    public static final double INFINITE_TO_FINITE_RANGE_INTERSECT_OVERLAP_HEURISTIC_FACTOR = 0.25;
    public static final double INFINITE_TO_INFINITE_RANGE_INTERSECT_OVERLAP_HEURISTIC_FACTOR = 0.5;
    private static final ColumnStatistics EMPTY = new ColumnStatistics(Estimate.unknown(), Estimate.unknown(), Estimate.unknown(), Optional.empty(), Optional.empty());
    private final Estimate nullsFraction;
    private final Estimate distinctValuesCount;
    private final Estimate dataSize;
    private final Optional<DoubleRange> range;
    private final Optional<ConnectorHistogram> histogram;

    public static ColumnStatistics empty() {
        return EMPTY;
    }

    public ColumnStatistics(Estimate nullsFraction, Estimate distinctValuesCount, Estimate dataSize, Optional<DoubleRange> range, Optional<ConnectorHistogram> histogram) {
        this.nullsFraction = Objects.requireNonNull(nullsFraction, "nullsFraction is null");
        if (!nullsFraction.isUnknown() && (nullsFraction.getValue() < 0.0 || nullsFraction.getValue() > 1.0)) {
            throw new IllegalArgumentException(String.format("nullsFraction must be between 0 and 1: %s", nullsFraction.getValue()));
        }
        this.distinctValuesCount = Objects.requireNonNull(distinctValuesCount, "distinctValuesCount is null");
        if (!distinctValuesCount.isUnknown() && distinctValuesCount.getValue() < 0.0) {
            throw new IllegalArgumentException(String.format("distinctValuesCount must be greater than or equal to 0: %s", distinctValuesCount.getValue()));
        }
        this.dataSize = Objects.requireNonNull(dataSize, "dataSize is null");
        if (!dataSize.isUnknown() && dataSize.getValue() < 0.0) {
            throw new IllegalArgumentException(String.format("dataSize must be greater than or equal to 0: %s", dataSize.getValue()));
        }
        this.range = Objects.requireNonNull(range, "range is null");
        this.histogram = Objects.requireNonNull(histogram, "histogram is null");
    }

    @JsonProperty
    public Estimate getNullsFraction() {
        return this.nullsFraction;
    }

    @JsonProperty
    public Estimate getDistinctValuesCount() {
        return this.distinctValuesCount;
    }

    @JsonProperty
    public Estimate getDataSize() {
        return this.dataSize;
    }

    @JsonProperty
    public Optional<DoubleRange> getRange() {
        return this.range;
    }

    @JsonProperty
    public Optional<ConnectorHistogram> getHistogram() {
        return this.histogram;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnStatistics that = (ColumnStatistics)o;
        return Objects.equals(this.nullsFraction, that.nullsFraction) && Objects.equals(this.distinctValuesCount, that.distinctValuesCount) && Objects.equals(this.dataSize, that.dataSize) && Objects.equals(this.range, that.range) && Objects.equals(this.histogram, that.histogram);
    }

    public int hashCode() {
        return Objects.hash(this.nullsFraction, this.distinctValuesCount, this.dataSize, this.range, this.histogram);
    }

    public String toString() {
        return "ColumnStatistics{nullsFraction=" + this.nullsFraction + ", distinctValuesCount=" + this.distinctValuesCount + ", dataSize=" + this.dataSize + ", range=" + this.range + ", histogram=" + this.histogram + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder buildFrom(ColumnStatistics statistics) {
        return new Builder().setRange(statistics.getRange()).setDataSize(statistics.getDataSize()).setNullsFraction(statistics.getNullsFraction()).setDistinctValuesCount(statistics.getDistinctValuesCount()).setHistogram(statistics.getHistogram());
    }

    public long getEstimatedSize() {
        return COLUMN_STATISTICS_SIZE + 3L * Estimate.ESTIMATE_SIZE + 2L * OPTION_SIZE + this.histogram.map(ConnectorHistogram::getEstimatedSize).orElse(0L) + this.range.map(unused -> DoubleRange.RANGE_SIZE).orElse(0L);
    }

    public static final class Builder {
        private Estimate nullsFraction = Estimate.unknown();
        private Estimate distinctValuesCount = Estimate.unknown();
        private Estimate dataSize = Estimate.unknown();
        private Optional<DoubleRange> range = Optional.empty();
        private Optional<ConnectorHistogram> histogram = Optional.empty();

        public Builder setNullsFraction(Estimate nullsFraction) {
            this.nullsFraction = Objects.requireNonNull(nullsFraction, "nullsFraction is null");
            return this;
        }

        public Estimate getNullsFraction() {
            return this.nullsFraction;
        }

        public Builder setDistinctValuesCount(Estimate distinctValuesCount) {
            this.distinctValuesCount = Objects.requireNonNull(distinctValuesCount, "distinctValuesCount is null");
            return this;
        }

        public Estimate getDistinctValuesCount() {
            return this.distinctValuesCount;
        }

        public Builder setDataSize(Estimate dataSize) {
            this.dataSize = Objects.requireNonNull(dataSize, "dataSize is null");
            return this;
        }

        public Estimate getDataSize() {
            return this.dataSize;
        }

        public Builder setRange(DoubleRange range) {
            this.range = Optional.of(Objects.requireNonNull(range, "range is null"));
            return this;
        }

        public Builder setRange(Optional<DoubleRange> range) {
            this.range = Objects.requireNonNull(range, "range is null");
            return this;
        }

        public Builder setHistogram(Optional<ConnectorHistogram> histogram) {
            this.histogram = histogram;
            return this;
        }

        public Optional<ConnectorHistogram> getHistogram() {
            return this.histogram;
        }

        public Builder mergeWith(Builder other) {
            if (this.nullsFraction.isUnknown()) {
                this.nullsFraction = other.nullsFraction;
            }
            if (this.distinctValuesCount.isUnknown()) {
                this.distinctValuesCount = other.distinctValuesCount;
            }
            if (this.dataSize.isUnknown()) {
                this.dataSize = other.dataSize;
            }
            if (!this.range.isPresent()) {
                this.range = other.range;
            }
            if (!this.histogram.isPresent()) {
                this.histogram = other.histogram;
            }
            return this;
        }

        public ColumnStatistics build() {
            return new ColumnStatistics(this.nullsFraction, this.distinctValuesCount, this.dataSize, this.range, this.histogram);
        }
    }
}

