/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc;

import com.facebook.presto.client.ClientSession;
import com.facebook.presto.client.QueryResults;
import com.facebook.presto.client.StatementClient;
import com.facebook.presto.jdbc.UserAgentRequestFilter;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.HostAndPort;
import io.airlift.http.client.AsyncHttpClient;
import io.airlift.http.client.HttpClientConfig;
import io.airlift.http.client.netty.NettyAsyncHttpClientConfig;
import io.airlift.http.client.netty.NettyIoPoolConfig;
import io.airlift.http.client.netty.StandaloneNettyAsyncHttpClient;
import io.airlift.json.JsonCodec;
import io.airlift.units.Duration;
import java.io.Closeable;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

class QueryExecutor
implements Closeable {
    private final JsonCodec<QueryResults> queryInfoCodec;
    private final AsyncHttpClient httpClient;

    private QueryExecutor(String userAgent, JsonCodec<QueryResults> queryResultsCodec, HostAndPort socksProxy) {
        Preconditions.checkNotNull((Object)userAgent, (Object)"userAgent is null");
        Preconditions.checkNotNull(queryResultsCodec, (Object)"queryResultsCodec is null");
        this.queryInfoCodec = queryResultsCodec;
        this.httpClient = new StandaloneNettyAsyncHttpClient("jdbc", new HttpClientConfig().setConnectTimeout(new Duration(10.0, TimeUnit.SECONDS)).setSocksProxy(socksProxy), new NettyAsyncHttpClientConfig(), new NettyIoPoolConfig(), (Set)ImmutableSet.of((Object)new UserAgentRequestFilter(userAgent)));
    }

    public StatementClient startQuery(ClientSession session, String query) {
        return new StatementClient(this.httpClient, this.queryInfoCodec, session, query);
    }

    @Override
    public void close() {
        this.httpClient.close();
    }

    protected void finalize() {
        this.close();
    }

    static QueryExecutor create(String userAgent) {
        return new QueryExecutor(userAgent, (JsonCodec<QueryResults>)JsonCodec.jsonCodec(QueryResults.class), QueryExecutor.getSystemSocksProxy());
    }

    @Nullable
    private static HostAndPort getSystemSocksProxy() {
        URI uri = URI.create("socket://0.0.0.0:80");
        for (Proxy proxy : ProxySelector.getDefault().select(uri)) {
            if (proxy.type() != Proxy.Type.SOCKS || !(proxy.address() instanceof InetSocketAddress)) continue;
            InetSocketAddress address = (InetSocketAddress)proxy.address();
            return HostAndPort.fromParts((String)address.getHostString(), (int)address.getPort());
        }
        return null;
    }
}

