/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.airlift.http.client;

import com.facebook.presto.jdbc.internal.airlift.http.client.FixedIntervalKeepAliveStrategy;
import com.facebook.presto.jdbc.internal.airlift.http.client.HttpClient;
import com.facebook.presto.jdbc.internal.airlift.http.client.HttpClientConfig;
import com.facebook.presto.jdbc.internal.airlift.http.client.HttpRequestFilter;
import com.facebook.presto.jdbc.internal.airlift.http.client.Request;
import com.facebook.presto.jdbc.internal.airlift.http.client.RequestStats;
import com.facebook.presto.jdbc.internal.airlift.http.client.Response;
import com.facebook.presto.jdbc.internal.airlift.http.client.ResponseHandler;
import com.facebook.presto.jdbc.internal.airlift.http.client.StatsHttpUriRequest;
import com.facebook.presto.jdbc.internal.airlift.units.Duration;
import com.facebook.presto.jdbc.internal.guava.annotations.Beta;
import com.facebook.presto.jdbc.internal.guava.annotations.VisibleForTesting;
import com.facebook.presto.jdbc.internal.guava.base.Preconditions;
import com.facebook.presto.jdbc.internal.guava.collect.ArrayListMultimap;
import com.facebook.presto.jdbc.internal.guava.collect.ImmutableList;
import com.facebook.presto.jdbc.internal.guava.collect.ListMultimap;
import com.facebook.presto.jdbc.internal.guava.io.CountingInputStream;
import com.facebook.presto.jdbc.internal.guava.primitives.Ints;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;

@Beta
public class ApacheHttpClient
implements HttpClient {
    private final RequestStats stats = new RequestStats();
    private final org.apache.http.client.HttpClient httpClient;
    private final List<HttpRequestFilter> requestFilters;

    public ApacheHttpClient() {
        this(new HttpClientConfig());
    }

    public ApacheHttpClient(HttpClientConfig config) {
        this(config, Collections.emptySet());
    }

    public ApacheHttpClient(HttpClientConfig config, Set<? extends HttpRequestFilter> requestFilters) {
        Preconditions.checkNotNull(config, "config is null");
        Preconditions.checkNotNull(requestFilters, "requestFilters is null");
        PoolingClientConnectionManager connectionManager = new PoolingClientConnectionManager();
        connectionManager.setMaxTotal(config.getMaxConnections());
        connectionManager.setDefaultMaxPerRoute(config.getMaxConnectionsPerServer());
        BasicHttpParams httpParams = new BasicHttpParams();
        httpParams.setParameter("http.socket.timeout", (Object)Ints.checkedCast(config.getReadTimeout().toMillis()));
        httpParams.setParameter("http.connection.timeout", (Object)Ints.checkedCast(config.getConnectTimeout().toMillis()));
        httpParams.setParameter("http.socket.linger", (Object)0);
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient((ClientConnectionManager)connectionManager, (HttpParams)httpParams);
        defaultHttpClient.setKeepAliveStrategy((ConnectionKeepAliveStrategy)new FixedIntervalKeepAliveStrategy(config.getKeepAliveInterval()));
        defaultHttpClient.setHttpRequestRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(0, false));
        this.httpClient = defaultHttpClient;
        this.requestFilters = ImmutableList.copyOf(requestFilters);
    }

    @VisibleForTesting
    List<HttpRequestFilter> getRequestFilters() {
        return this.requestFilters;
    }

    @Override
    @PreDestroy
    public void close() {
        this.httpClient.getConnectionManager().shutdown();
    }

    @Override
    @Managed
    @Flatten
    public RequestStats getStats() {
        return this.stats;
    }

    @Override
    public <T, E extends Exception> T execute(Request request, final ResponseHandler<T, E> responseHandler) throws E {
        Preconditions.checkNotNull(request, "request is null");
        Preconditions.checkNotNull(responseHandler, "responseHandler is null");
        for (HttpRequestFilter requestFilter : this.requestFilters) {
            request = requestFilter.filterRequest(request);
        }
        final long requestStart = System.nanoTime();
        final StatsHttpUriRequest httpUriRequest = StatsHttpUriRequest.createGenericHttpRequest(request);
        final Request finalRequest = request;
        try {
            Object value = this.httpClient.execute((HttpUriRequest)httpUriRequest, new org.apache.http.client.ResponseHandler<T>(){

                public T handleResponse(HttpResponse httpResponse) throws IOException {
                    long responseStart = System.nanoTime();
                    MyResponse response = new MyResponse(httpResponse);
                    try {
                        Object value;
                        Object t = value = responseHandler.handle(finalRequest, response);
                        return t;
                    }
                    catch (Exception e) {
                        throw new ExceptionFromResponseHandler(e);
                    }
                    finally {
                        Duration responseProcessingTime = Duration.nanosSince(responseStart);
                        Duration requestProcessingTime = new Duration(responseStart - requestStart, TimeUnit.NANOSECONDS);
                        ApacheHttpClient.this.stats.record(finalRequest.getMethod(), response.getStatusCode(), httpUriRequest.getBytesWritten(), response.getBytesRead(), requestProcessingTime, responseProcessingTime);
                    }
                }
            });
            return (T)value;
        }
        catch (Exception e) {
            if (e instanceof ExceptionFromResponseHandler) {
                try {
                    throw (Exception)e.getCause();
                }
                catch (ClassCastException classCastException) {
                }
            } else if (e instanceof ConnectTimeoutException) {
                SocketTimeoutException socketTimeoutException = new SocketTimeoutException(e.getMessage());
                socketTimeoutException.setStackTrace(e.getStackTrace());
                return responseHandler.handleException(request, socketTimeoutException);
            }
            return responseHandler.handleException(request, e);
        }
    }

    static class MyResponse
    implements Response {
        private final HttpResponse response;
        private CountingInputStream countingInputStream;

        public MyResponse(HttpResponse response) {
            this.response = response;
        }

        @Override
        public int getStatusCode() {
            return this.response.getStatusLine().getStatusCode();
        }

        @Override
        public String getStatusMessage() {
            return this.response.getStatusLine().getReasonPhrase();
        }

        @Override
        public String getHeader(String name) {
            Header header = this.response.getFirstHeader(name);
            if (header != null) {
                return header.getValue();
            }
            return null;
        }

        @Override
        public ListMultimap<String, String> getHeaders() {
            ArrayListMultimap<String, String> multimap = ArrayListMultimap.create();
            for (Header header : this.response.getAllHeaders()) {
                multimap.put((Object)header.getName(), (Object)header.getValue());
            }
            return multimap;
        }

        @Override
        public long getBytesRead() {
            if (this.countingInputStream == null) {
                return 0L;
            }
            return this.countingInputStream.getCount();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            InputStream content;
            HttpEntity entity;
            if (this.countingInputStream == null && (entity = this.response.getEntity()) != null && (content = entity.getContent()) != null) {
                this.countingInputStream = new CountingInputStream(content);
            }
            if (this.countingInputStream == null) {
                throw new IOException("No input stream");
            }
            return this.countingInputStream;
        }
    }

    private static class ExceptionFromResponseHandler
    extends IOException {
        private ExceptionFromResponseHandler(Exception cause) {
            super(Preconditions.checkNotNull(cause, "cause is null"));
        }
    }
}

