/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.airlift.http.client;

import com.facebook.presto.jdbc.internal.airlift.configuration.Config;
import com.facebook.presto.jdbc.internal.airlift.units.Duration;
import com.facebook.presto.jdbc.internal.airlift.units.MinDuration;
import com.facebook.presto.jdbc.internal.guava.annotations.Beta;
import com.facebook.presto.jdbc.internal.guava.net.HostAndPort;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@Beta
public class HttpClientConfig {
    private Duration connectTimeout = new Duration(1.0, TimeUnit.SECONDS);
    private Duration readTimeout = new Duration(1.0, TimeUnit.MINUTES);
    private Duration keepAliveInterval = null;
    private int maxConnections = 200;
    private int maxConnectionsPerServer = 20;
    private HostAndPort socksProxy;

    @NotNull
    @MinDuration(value="0ms")
    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    @Config(value="http-client.connect-timeout")
    public HttpClientConfig setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    @NotNull
    @MinDuration(value="0ms")
    public Duration getReadTimeout() {
        return this.readTimeout;
    }

    @Config(value="http-client.read-timeout")
    public HttpClientConfig setReadTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public Duration getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    @Config(value="http-client.keep-alive-interval")
    public HttpClientConfig setKeepAliveInterval(Duration keepAliveInterval) {
        this.keepAliveInterval = keepAliveInterval;
        return this;
    }

    @Min(value=1L)
    public int getMaxConnections() {
        return this.maxConnections;
    }

    @Config(value="http-client.max-connections")
    public HttpClientConfig setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
        return this;
    }

    @Min(value=1L)
    public int getMaxConnectionsPerServer() {
        return this.maxConnectionsPerServer;
    }

    @Config(value="http-client.max-connections-per-server")
    public HttpClientConfig setMaxConnectionsPerServer(int maxConnectionsPerServer) {
        this.maxConnectionsPerServer = maxConnectionsPerServer;
        return this;
    }

    public HostAndPort getSocksProxy() {
        return this.socksProxy;
    }

    @Config(value="http-client.socks-proxy")
    public HttpClientConfig setSocksProxy(HostAndPort socksProxy) {
        this.socksProxy = socksProxy;
        return this;
    }
}

