/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.airlift.http.client;

import com.facebook.presto.jdbc.internal.airlift.http.client.Request;
import com.facebook.presto.jdbc.internal.airlift.http.client.Response;
import com.facebook.presto.jdbc.internal.airlift.http.client.ResponseHandler;
import com.facebook.presto.jdbc.internal.airlift.http.client.UnexpectedResponseException;
import com.facebook.presto.jdbc.internal.airlift.json.JsonCodec;
import com.facebook.presto.jdbc.internal.guava.collect.ImmutableSet;
import com.facebook.presto.jdbc.internal.guava.io.ByteStreams;
import com.facebook.presto.jdbc.internal.guava.net.MediaType;
import com.facebook.presto.jdbc.internal.guava.primitives.Ints;
import java.io.IOException;
import java.net.ConnectException;
import java.nio.charset.StandardCharsets;
import java.util.Set;

public class JsonResponseHandler<T>
implements ResponseHandler<T, RuntimeException> {
    private static final MediaType MEDIA_TYPE_JSON = MediaType.create("application", "json");
    private final JsonCodec<T> jsonCodec;
    private final Set<Integer> successfulResponseCodes;

    public static <T> JsonResponseHandler<T> createJsonResponseHandler(JsonCodec<T> jsonCodec) {
        return new JsonResponseHandler<T>(jsonCodec);
    }

    public static <T> JsonResponseHandler<T> createJsonResponseHandler(JsonCodec<T> jsonCodec, int firstSuccessfulResponseCode, int ... otherSuccessfulResponseCodes) {
        return new JsonResponseHandler<T>(jsonCodec, firstSuccessfulResponseCode, otherSuccessfulResponseCodes);
    }

    private JsonResponseHandler(JsonCodec<T> jsonCodec) {
        this(jsonCodec, 200, 201, 202, 203, 204, 205, 206);
    }

    private JsonResponseHandler(JsonCodec<T> jsonCodec, int firstSuccessfulResponseCode, int ... otherSuccessfulResponseCodes) {
        this.jsonCodec = jsonCodec;
        this.successfulResponseCodes = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add((Object)firstSuccessfulResponseCode)).addAll(Ints.asList(otherSuccessfulResponseCodes))).build();
    }

    @Override
    public T handleException(Request request, Exception exception) {
        if (exception instanceof ConnectException) {
            throw new RuntimeException("Server refused connection: " + request.getUri().toASCIIString(), exception);
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw new RuntimeException(exception);
    }

    @Override
    public T handle(Request request, Response response) {
        byte[] bytes;
        if (!this.successfulResponseCodes.contains(response.getStatusCode())) {
            throw new UnexpectedResponseException(String.format("Expected response code to be %s, but was %d: %s", this.successfulResponseCodes, response.getStatusCode(), response.getStatusMessage()), request, response);
        }
        String contentType = response.getHeader("Content-Type");
        if (contentType == null) {
            throw new UnexpectedResponseException("Content-Type is not set for response", request, response);
        }
        if (!MediaType.parse(contentType).is(MEDIA_TYPE_JSON)) {
            throw new UnexpectedResponseException("Expected application/json response from server but got " + contentType, request, response);
        }
        try {
            bytes = ByteStreams.toByteArray(response.getInputStream());
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading response from server");
        }
        try {
            return this.jsonCodec.fromJson(bytes);
        }
        catch (IllegalArgumentException e) {
            String json = new String(bytes, StandardCharsets.UTF_8);
            throw new IllegalArgumentException("Unable to create " + this.jsonCodec.getType() + " from JSON response:\n" + json, e);
        }
    }
}

