/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.airlift.http.client;

import com.facebook.presto.jdbc.internal.airlift.http.client.Request;
import com.facebook.presto.jdbc.internal.airlift.http.client.Response;
import com.facebook.presto.jdbc.internal.airlift.http.client.ResponseHandler;
import com.facebook.presto.jdbc.internal.guava.collect.ImmutableListMultimap;
import com.facebook.presto.jdbc.internal.guava.collect.ListMultimap;
import java.net.ConnectException;
import java.util.List;

public class StatusResponseHandler
implements ResponseHandler<StatusResponse, RuntimeException> {
    private static final StatusResponseHandler statusResponseHandler = new StatusResponseHandler();

    public static StatusResponseHandler createStatusResponseHandler() {
        return statusResponseHandler;
    }

    private StatusResponseHandler() {
    }

    @Override
    public StatusResponse handleException(Request request, Exception exception) {
        if (exception instanceof ConnectException) {
            throw new RuntimeException("Server refused connection: " + request.getUri().toASCIIString(), exception);
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw new RuntimeException(exception);
    }

    @Override
    public StatusResponse handle(Request request, Response response) {
        return new StatusResponse(response.getStatusCode(), response.getStatusMessage(), response.getHeaders());
    }

    public static class StatusResponse {
        private final int statusCode;
        private final String statusMessage;
        private final ListMultimap<String, String> headers;

        public StatusResponse(int statusCode, String statusMessage, ListMultimap<String, String> headers) {
            this.statusCode = statusCode;
            this.statusMessage = statusMessage;
            this.headers = ImmutableListMultimap.copyOf(headers);
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getStatusMessage() {
            return this.statusMessage;
        }

        public String getHeader(String name) {
            List<String> values = this.getHeaders().get(name);
            if (values.isEmpty()) {
                return null;
            }
            return values.get(0);
        }

        public ListMultimap<String, String> getHeaders() {
            return this.headers;
        }
    }
}

