/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.airlift.http.client;

import com.facebook.presto.jdbc.internal.airlift.http.client.Request;
import com.facebook.presto.jdbc.internal.airlift.http.client.Response;
import com.facebook.presto.jdbc.internal.airlift.http.client.ResponseHandler;
import com.facebook.presto.jdbc.internal.guava.base.Charsets;
import com.facebook.presto.jdbc.internal.guava.base.Throwables;
import com.facebook.presto.jdbc.internal.guava.collect.ImmutableListMultimap;
import com.facebook.presto.jdbc.internal.guava.collect.ListMultimap;
import com.facebook.presto.jdbc.internal.guava.io.ByteStreams;
import com.facebook.presto.jdbc.internal.guava.net.MediaType;
import java.io.IOException;
import java.net.ConnectException;
import java.util.List;

public class StringResponseHandler
implements ResponseHandler<StringResponse, RuntimeException> {
    private static final StringResponseHandler STRING_RESPONSE_HANDLER = new StringResponseHandler();

    public static StringResponseHandler createStringResponseHandler() {
        return STRING_RESPONSE_HANDLER;
    }

    private StringResponseHandler() {
    }

    @Override
    public StringResponse handleException(Request request, Exception exception) {
        if (exception instanceof ConnectException) {
            throw new RuntimeException("Server refused connection: " + request.getUri().toASCIIString(), exception);
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw new RuntimeException(exception);
    }

    @Override
    public StringResponse handle(Request request, Response response) {
        try {
            String contentType = response.getHeader("Content-Type");
            if (contentType != null) {
                MediaType mediaType = MediaType.parse(contentType);
                return new StringResponse(response.getStatusCode(), response.getStatusMessage(), response.getHeaders(), new String(ByteStreams.toByteArray(response.getInputStream()), mediaType.charset().or(Charsets.UTF_8)));
            }
            return new StringResponse(response.getStatusCode(), response.getStatusMessage(), response.getHeaders(), new String(ByteStreams.toByteArray(response.getInputStream()), Charsets.UTF_8));
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
    }

    public static class StringResponse {
        private final int statusCode;
        private final String statusMessage;
        private final ListMultimap<String, String> headers;
        private final String body;

        public StringResponse(int statusCode, String statusMessage, ListMultimap<String, String> headers, String body) {
            this.statusCode = statusCode;
            this.statusMessage = statusMessage;
            this.headers = ImmutableListMultimap.copyOf(headers);
            this.body = body;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getStatusMessage() {
            return this.statusMessage;
        }

        public String getBody() {
            return this.body;
        }

        public String getHeader(String name) {
            List<String> values = this.getHeaders().get(name);
            if (values.isEmpty()) {
                return null;
            }
            return values.get(0);
        }

        public ListMultimap<String, String> getHeaders() {
            return this.headers;
        }
    }
}

