/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.airlift.http.client.netty;

import com.facebook.presto.jdbc.internal.airlift.http.client.netty.NettyConnectionPool;
import com.facebook.presto.jdbc.internal.airlift.http.client.netty.NettyHttpResponseChannelHandler;
import com.facebook.presto.jdbc.internal.airlift.units.DataSize;
import com.facebook.presto.jdbc.internal.airlift.units.Duration;
import com.facebook.presto.jdbc.internal.guava.base.Preconditions;
import com.facebook.presto.jdbc.internal.guava.primitives.Ints;
import com.facebook.presto.jdbc.internal.netty.channel.ChannelPipeline;
import com.facebook.presto.jdbc.internal.netty.channel.ChannelPipelineFactory;
import com.facebook.presto.jdbc.internal.netty.channel.Channels;
import com.facebook.presto.jdbc.internal.netty.handler.codec.http.HttpChunkAggregator;
import com.facebook.presto.jdbc.internal.netty.handler.codec.http.HttpClientCodec;
import com.facebook.presto.jdbc.internal.netty.handler.codec.http.HttpContentDecompressor;
import com.facebook.presto.jdbc.internal.netty.handler.execution.ExecutionHandler;
import com.facebook.presto.jdbc.internal.netty.handler.execution.OrderedMemoryAwareThreadPoolExecutor;
import com.facebook.presto.jdbc.internal.netty.handler.timeout.ReadTimeoutHandler;
import com.facebook.presto.jdbc.internal.netty.util.Timer;
import java.util.concurrent.TimeUnit;

public class HttpClientPipelineFactory
implements ChannelPipelineFactory {
    private final Timer timer;
    private final OrderedMemoryAwareThreadPoolExecutor executor;
    private final ReadTimeoutHandler timeoutHandler;
    private final NettyConnectionPool nettyConnectionPool;
    private final int maxContentLength;

    public HttpClientPipelineFactory(NettyConnectionPool nettyConnectionPool, Timer timer, OrderedMemoryAwareThreadPoolExecutor executor, Duration readTimeout, DataSize maxContentLength) {
        this.timer = timer;
        Preconditions.checkNotNull(nettyConnectionPool, "nettyConnectionPool is null");
        Preconditions.checkNotNull(executor, "executor is null");
        Preconditions.checkNotNull(readTimeout, "readTimeout is null");
        Preconditions.checkNotNull(maxContentLength, "maxContentLength is null");
        this.nettyConnectionPool = nettyConnectionPool;
        this.executor = executor;
        this.timeoutHandler = new ReadTimeoutHandler(this.timer, readTimeout.toMillis(), TimeUnit.MILLISECONDS);
        this.maxContentLength = Ints.checkedCast(maxContentLength.toBytes());
    }

    @Override
    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline pipeline = Channels.pipeline();
        pipeline.addLast("timeout", this.timeoutHandler);
        pipeline.addLast("codec", new HttpClientCodec());
        pipeline.addLast("inflater", new HttpContentDecompressor());
        pipeline.addLast("aggregator", new HttpChunkAggregator(this.maxContentLength));
        pipeline.addLast("pipelineExecutor", new ExecutionHandler(this.executor));
        pipeline.addLast("handler", new NettyHttpResponseChannelHandler(this.nettyConnectionPool));
        return pipeline;
    }
}

