/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.airlift.http.client.netty;

import com.facebook.presto.jdbc.internal.airlift.concurrent.ThreadPoolExecutorMBean;
import com.facebook.presto.jdbc.internal.airlift.concurrent.Threads;
import com.facebook.presto.jdbc.internal.airlift.http.client.AsyncHttpClient;
import com.facebook.presto.jdbc.internal.airlift.http.client.BodyGenerator;
import com.facebook.presto.jdbc.internal.airlift.http.client.HttpClientConfig;
import com.facebook.presto.jdbc.internal.airlift.http.client.HttpRequestFilter;
import com.facebook.presto.jdbc.internal.airlift.http.client.Request;
import com.facebook.presto.jdbc.internal.airlift.http.client.RequestStats;
import com.facebook.presto.jdbc.internal.airlift.http.client.ResponseHandler;
import com.facebook.presto.jdbc.internal.airlift.http.client.netty.CanceledRequestException;
import com.facebook.presto.jdbc.internal.airlift.http.client.netty.HttpClientPipelineFactory;
import com.facebook.presto.jdbc.internal.airlift.http.client.netty.NettyAsyncHttpClientConfig;
import com.facebook.presto.jdbc.internal.airlift.http.client.netty.NettyConnectionPool;
import com.facebook.presto.jdbc.internal.airlift.http.client.netty.NettyHttpResponseChannelHandler;
import com.facebook.presto.jdbc.internal.airlift.http.client.netty.NettyIoPool;
import com.facebook.presto.jdbc.internal.airlift.http.client.netty.NettyResponseFuture;
import com.facebook.presto.jdbc.internal.airlift.http.client.netty.UnknownRequestException;
import com.facebook.presto.jdbc.internal.airlift.http.client.netty.socks.Socks4ClientBootstrap;
import com.facebook.presto.jdbc.internal.guava.annotations.Beta;
import com.facebook.presto.jdbc.internal.guava.annotations.VisibleForTesting;
import com.facebook.presto.jdbc.internal.guava.base.Preconditions;
import com.facebook.presto.jdbc.internal.guava.base.Throwables;
import com.facebook.presto.jdbc.internal.guava.collect.ImmutableList;
import com.facebook.presto.jdbc.internal.netty.bootstrap.ClientBootstrap;
import com.facebook.presto.jdbc.internal.netty.buffer.ChannelBufferOutputStream;
import com.facebook.presto.jdbc.internal.netty.buffer.DynamicChannelBuffer;
import com.facebook.presto.jdbc.internal.netty.channel.Channel;
import com.facebook.presto.jdbc.internal.netty.channel.ChannelFuture;
import com.facebook.presto.jdbc.internal.netty.channel.ChannelFutureListener;
import com.facebook.presto.jdbc.internal.netty.channel.socket.nio.NioClientSocketChannelFactory;
import com.facebook.presto.jdbc.internal.netty.handler.codec.http.DefaultHttpRequest;
import com.facebook.presto.jdbc.internal.netty.handler.codec.http.HttpMethod;
import com.facebook.presto.jdbc.internal.netty.handler.codec.http.HttpRequest;
import com.facebook.presto.jdbc.internal.netty.handler.codec.http.HttpVersion;
import com.facebook.presto.jdbc.internal.netty.handler.execution.OrderedMemoryAwareThreadPoolExecutor;
import com.facebook.presto.jdbc.internal.netty.util.HashedWheelTimer;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

@Beta
public class NettyAsyncHttpClient
implements AsyncHttpClient {
    private final RequestStats stats = new RequestStats();
    private final List<HttpRequestFilter> requestFilters;
    private final OrderedMemoryAwareThreadPoolExecutor executor;
    private final ThreadPoolExecutorMBean executorMBean;
    private final NettyConnectionPool nettyConnectionPool;
    private final HashedWheelTimer timer;

    public NettyAsyncHttpClient(String name, HttpClientConfig config, NettyIoPool ioPool) {
        this(name, ioPool, config, new NettyAsyncHttpClientConfig(), Collections.emptySet());
    }

    public NettyAsyncHttpClient(String name, NettyIoPool ioPool, HttpClientConfig config, NettyAsyncHttpClientConfig asyncConfig, Set<? extends HttpRequestFilter> requestFilters) {
        Preconditions.checkNotNull(name, "name is null");
        Preconditions.checkNotNull(ioPool, "ioPool is null");
        Preconditions.checkNotNull(config, "config is null");
        Preconditions.checkNotNull(asyncConfig, "asyncConfig is null");
        Preconditions.checkNotNull(requestFilters, "requestFilters is null");
        this.requestFilters = ImmutableList.copyOf(requestFilters);
        String namePrefix = "http-client-" + name;
        this.timer = new HashedWheelTimer(Threads.daemonThreadsNamed(namePrefix + "-timer-%s"));
        NioClientSocketChannelFactory channelFactory = new NioClientSocketChannelFactory(ioPool.getBossPool(), ioPool.getWorkerPool());
        ThreadFactory workerThreadFactory = Threads.daemonThreadsNamed(namePrefix + "-worker-%s");
        this.executor = new OrderedMemoryAwareThreadPoolExecutor(asyncConfig.getWorkerThreads(), 0L, 0L, 30L, TimeUnit.SECONDS, workerThreadFactory);
        this.executorMBean = new ThreadPoolExecutorMBean(this.executor);
        ClientBootstrap bootstrap = config.getSocksProxy() == null ? new ClientBootstrap(channelFactory) : new Socks4ClientBootstrap(channelFactory, config.getSocksProxy());
        bootstrap.setOption("connectTimeoutMillis", config.getConnectTimeout().toMillis());
        bootstrap.setOption("soLinger", 0);
        this.nettyConnectionPool = new NettyConnectionPool(bootstrap, config.getMaxConnections(), this.executor, asyncConfig.isEnableConnectionPooling());
        HttpClientPipelineFactory pipelineFactory = new HttpClientPipelineFactory(this.nettyConnectionPool, this.timer, this.executor, config.getReadTimeout(), asyncConfig.getMaxContentLength());
        bootstrap.setPipelineFactory(pipelineFactory);
    }

    public List<HttpRequestFilter> getRequestFilters() {
        return this.requestFilters;
    }

    @Override
    @PreDestroy
    public void close() {
        try {
            this.executor.shutdownNow();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.nettyConnectionPool.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.timer.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public <T, E extends Exception> T execute(Request request, ResponseHandler<T, E> responseHandler) throws E {
        try {
            return (T)this.executeAsync(request, responseHandler).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Throwables.propagate(e);
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible(e.getCause());
            if (e.getCause() instanceof Exception) {
                throw (Exception)e.getCause();
            }
            throw Throwables.propagate(e.getCause());
        }
    }

    @Override
    @Managed
    @Flatten
    public RequestStats getStats() {
        return this.stats;
    }

    @Managed
    @Nested
    public ThreadPoolExecutorMBean getExecutor() {
        return this.executorMBean;
    }

    @Override
    public <T, E extends Exception> AsyncHttpClient.AsyncHttpResponseFuture<T> executeAsync(Request request, ResponseHandler<T, E> responseHandler) {
        for (HttpRequestFilter requestFilter : this.requestFilters) {
            request = requestFilter.filterRequest(request);
        }
        Preconditions.checkArgument("http".equalsIgnoreCase(request.getUri().getScheme()) || "https".equalsIgnoreCase(request.getUri().getScheme()), "%s only supports http and https requests", this.getClass().getSimpleName());
        NettyResponseFuture<T, E> nettyResponseFuture = new NettyResponseFuture<T, E>(request, responseHandler, this.stats);
        this.nettyConnectionPool.execute(request.getUri(), new HttpConnectionCallback<T, E>(request, nettyResponseFuture));
        return nettyResponseFuture;
    }

    @VisibleForTesting
    public static HttpRequest buildNettyHttpRequest(Request request) throws Exception {
        URI uri = request.getUri();
        StringBuilder pathBuilder = new StringBuilder(100);
        if (uri.getRawPath() == null || uri.getRawPath().isEmpty()) {
            pathBuilder.append('/');
        } else {
            pathBuilder.append(uri.getRawPath());
        }
        if (uri.getRawQuery() != null) {
            pathBuilder.append('?').append(uri.getRawQuery());
        }
        DefaultHttpRequest nettyRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, new HttpMethod(request.getMethod()), pathBuilder.toString());
        if (uri.getPort() == -1) {
            nettyRequest.setHeader("Host", uri.getHost());
        } else {
            nettyRequest.setHeader("Host", uri.getHost() + ":" + uri.getPort());
        }
        for (Map.Entry<String, Collection<String>> header : request.getHeaders().asMap().entrySet()) {
            nettyRequest.setHeader(header.getKey(), (Iterable)header.getValue());
        }
        BodyGenerator bodyGenerator = request.getBodyGenerator();
        if (bodyGenerator != null) {
            DynamicChannelBuffer content = new DynamicChannelBuffer(65536);
            ChannelBufferOutputStream out = new ChannelBufferOutputStream(content);
            bodyGenerator.write(out);
            nettyRequest.setHeader("Content-Length", content.readableBytes());
            nettyRequest.setContent(content);
        }
        return nettyRequest;
    }

    private static class HttpConnectionCallback<T, E extends Exception>
    implements NettyConnectionPool.ConnectionCallback {
        private final Request request;
        private final NettyResponseFuture<T, E> nettyResponseFuture;

        public HttpConnectionCallback(Request request, NettyResponseFuture<T, E> nettyResponseFuture) {
            this.request = request;
            this.nettyResponseFuture = nettyResponseFuture;
        }

        @Override
        public void run(Channel channel) throws Exception {
            this.nettyResponseFuture.setState(NettyResponseFuture.NettyAsyncHttpState.SENDING_REQUEST);
            channel.getPipeline().getContext(NettyHttpResponseChannelHandler.class).setAttachment(this.nettyResponseFuture);
            HttpRequest nettyRequest = NettyAsyncHttpClient.buildNettyHttpRequest(this.request);
            channel.write(nettyRequest).addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        HttpConnectionCallback.this.nettyResponseFuture.setState(NettyResponseFuture.NettyAsyncHttpState.WAITING_FOR_RESPONSE);
                    } else if (future.isCancelled()) {
                        HttpConnectionCallback.this.nettyResponseFuture.failed(new CanceledRequestException());
                    } else {
                        Throwable cause = future.getCause();
                        if (cause == null) {
                            cause = new UnknownRequestException();
                        }
                        HttpConnectionCallback.this.nettyResponseFuture.failed(cause);
                    }
                }
            });
        }

        @Override
        public void onError(Throwable throwable) {
            this.nettyResponseFuture.failed(throwable);
        }
    }
}

