/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.airlift.http.client.netty;

import com.facebook.presto.jdbc.internal.airlift.configuration.Config;
import com.facebook.presto.jdbc.internal.airlift.units.DataSize;
import com.facebook.presto.jdbc.internal.guava.annotations.Beta;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@Beta
public class NettyAsyncHttpClientConfig {
    private int workerThreads = Runtime.getRuntime().availableProcessors() * 4;
    private DataSize maxContentLength = new DataSize(16.0, DataSize.Unit.MEGABYTE);
    private boolean enableConnectionPooling;

    @Min(value=1L)
    public int getWorkerThreads() {
        return this.workerThreads;
    }

    @Config(value="http-client.threads")
    public NettyAsyncHttpClientConfig setWorkerThreads(int workerThreads) {
        this.workerThreads = workerThreads;
        return this;
    }

    @NotNull
    public DataSize getMaxContentLength() {
        return this.maxContentLength;
    }

    @Config(value="http-client.max-content-length")
    public NettyAsyncHttpClientConfig setMaxContentLength(DataSize maxContentLength) {
        this.maxContentLength = maxContentLength;
        return this;
    }

    public boolean isEnableConnectionPooling() {
        return this.enableConnectionPooling;
    }

    @Config(value="http-client.pool-connections")
    public NettyAsyncHttpClientConfig setEnableConnectionPooling(boolean enableConnectionPooling) {
        this.enableConnectionPooling = enableConnectionPooling;
        return this;
    }
}

