/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.airlift.http.client.netty;

import com.facebook.presto.jdbc.internal.airlift.concurrent.Threads;
import com.facebook.presto.jdbc.internal.airlift.http.client.netty.NettyIoPoolConfig;
import com.facebook.presto.jdbc.internal.guava.annotations.Beta;
import com.facebook.presto.jdbc.internal.guava.base.Preconditions;
import com.facebook.presto.jdbc.internal.netty.channel.socket.nio.NioClientBossPool;
import com.facebook.presto.jdbc.internal.netty.channel.socket.nio.NioWorkerPool;
import com.facebook.presto.jdbc.internal.netty.util.HashedWheelTimer;
import com.facebook.presto.jdbc.internal.netty.util.ThreadNameDeterminer;
import java.io.Closeable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PreDestroy;

@Beta
public class NettyIoPool
implements Closeable {
    private final HashedWheelTimer hashedWheelTimer;
    private final ExecutorService bossExecutor;
    private final ExecutorService workerExecutor;
    private final NioWorkerPool workerPool;
    private final NioClientBossPool bossPool;
    private final String name;

    public NettyIoPool(String name) {
        this(name, new NettyIoPoolConfig());
    }

    public NettyIoPool(String name, NettyIoPoolConfig config) {
        this.name = Preconditions.checkNotNull(name, "name is null");
        Preconditions.checkNotNull(config, "config is null");
        String prefix = "netty-client-" + name + "-io-";
        String nameFormat = prefix + "timer-%s";
        this.hashedWheelTimer = new HashedWheelTimer(Threads.daemonThreadsNamed(nameFormat));
        this.bossExecutor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed(prefix + "boss-%s"));
        this.workerExecutor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed(prefix + "worker-%s"));
        this.bossPool = new NioClientBossPool(this.bossExecutor, config.getIoBossThreads(), this.hashedWheelTimer, ThreadNameDeterminer.CURRENT);
        this.workerPool = new NioWorkerPool((Executor)this.workerExecutor, config.getIoWorkerThreads(), ThreadNameDeterminer.CURRENT);
    }

    public NioClientBossPool getBossPool() {
        return this.bossPool;
    }

    public NioWorkerPool getWorkerPool() {
        return this.workerPool;
    }

    @Override
    @PreDestroy
    public void close() {
        try {
            this.bossPool.shutdown();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.workerPool.shutdown();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.hashedWheelTimer.stop();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.bossExecutor.shutdownNow();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.workerExecutor.shutdownNow();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toString() {
        return "Netty IO Pool for " + this.name;
    }
}

