/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.airlift.http.client.netty;

import com.facebook.presto.jdbc.internal.airlift.configuration.Config;
import com.facebook.presto.jdbc.internal.guava.annotations.Beta;
import javax.validation.constraints.Min;

@Beta
public class NettyIoPoolConfig {
    private int ioBossThreads = 1;
    private int ioWorkerThreads = Runtime.getRuntime().availableProcessors() * 2;

    @Min(value=1L)
    public int getIoBossThreads() {
        return this.ioBossThreads;
    }

    @Config(value="http-client.shared-io-boss-threads")
    public NettyIoPoolConfig setIoBossThreads(int ioBossThreads) {
        this.ioBossThreads = ioBossThreads;
        return this;
    }

    @Min(value=2L)
    public int getIoWorkerThreads() {
        return this.ioWorkerThreads;
    }

    @Config(value="http-client.shared-io-worker-threads")
    public NettyIoPoolConfig setIoWorkerThreads(int ioWorkerThreads) {
        this.ioWorkerThreads = ioWorkerThreads;
        return this;
    }
}

