/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.airlift.http.client.netty;

import com.facebook.presto.jdbc.internal.airlift.http.client.Response;
import com.facebook.presto.jdbc.internal.guava.collect.ImmutableListMultimap;
import com.facebook.presto.jdbc.internal.guava.collect.ListMultimap;
import com.facebook.presto.jdbc.internal.netty.buffer.ChannelBuffer;
import com.facebook.presto.jdbc.internal.netty.handler.codec.http.HttpResponse;
import com.facebook.presto.jdbc.internal.netty.handler.codec.http.HttpResponseStatus;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public class NettyResponse
implements Response {
    private final int statusCode;
    private final String statusMessage;
    private final ListMultimap<String, String> headers;
    private final byte[] content;

    public NettyResponse(HttpResponse httpResponse) {
        HttpResponseStatus status = httpResponse.getStatus();
        this.statusCode = status.getCode();
        this.statusMessage = status.getReasonPhrase();
        ImmutableListMultimap.Builder headers = ImmutableListMultimap.builder();
        for (Map.Entry<String, String> header : httpResponse.getHeaders()) {
            headers.put(header);
        }
        this.headers = headers.build();
        ChannelBuffer content = httpResponse.getContent();
        byte[] bytes = new byte[content.readableBytes()];
        content.getBytes(content.readerIndex(), bytes);
        this.content = bytes;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public String getStatusMessage() {
        return this.statusMessage;
    }

    @Override
    public String getHeader(String name) {
        List<String> values = this.headers.get(name);
        if (values != null && !values.isEmpty()) {
            return values.get(0);
        }
        return null;
    }

    @Override
    public ListMultimap<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public long getBytesRead() {
        return this.content.length;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.content);
    }
}

