/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.airlift.http.client.netty;

import com.facebook.presto.jdbc.internal.airlift.http.client.AsyncHttpClient;
import com.facebook.presto.jdbc.internal.airlift.http.client.Request;
import com.facebook.presto.jdbc.internal.airlift.http.client.RequestStats;
import com.facebook.presto.jdbc.internal.airlift.http.client.ResponseHandler;
import com.facebook.presto.jdbc.internal.airlift.http.client.netty.NettyResponse;
import com.facebook.presto.jdbc.internal.airlift.log.Logger;
import com.facebook.presto.jdbc.internal.airlift.units.Duration;
import com.facebook.presto.jdbc.internal.guava.base.Objects;
import com.facebook.presto.jdbc.internal.guava.util.concurrent.AbstractFuture;
import com.facebook.presto.jdbc.internal.netty.handler.codec.http.HttpResponse;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

class NettyResponseFuture<T, E extends Exception>
extends AbstractFuture<T>
implements AsyncHttpClient.AsyncHttpResponseFuture<T> {
    private static final Logger log = Logger.get(NettyResponseFuture.class);
    private final long requestStart = System.nanoTime();
    private final AtomicReference<NettyAsyncHttpState> state = new AtomicReference<NettyAsyncHttpState>(NettyAsyncHttpState.WAITING_FOR_CONNECTION);
    private final Request request;
    private final ResponseHandler<T, E> responseHandler;
    private final RequestStats stats;

    public NettyResponseFuture(Request request, ResponseHandler<T, E> responseHandler, RequestStats stats) {
        this.request = request;
        this.responseHandler = responseHandler;
        this.stats = stats;
    }

    @Override
    public String getState() {
        return this.state.get().toString();
    }

    protected void setState(NettyAsyncHttpState state) {
        this.state.set(state);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.state.set(NettyAsyncHttpState.CANCELED);
        return super.cancel(mayInterruptIfRunning);
    }

    protected void completed(HttpResponse httpResponse) {
        T value;
        if (this.state.get() == NettyAsyncHttpState.CANCELED) {
            return;
        }
        try {
            value = this.processResponse(httpResponse);
        }
        catch (Throwable e) {
            this.storeException(e);
            return;
        }
        this.state.set(NettyAsyncHttpState.DONE);
        this.set(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T processResponse(HttpResponse httpResponse) throws E {
        T value;
        long responseStart = System.nanoTime();
        this.state.set(NettyAsyncHttpState.PROCESSING_RESPONSE);
        NettyResponse response = null;
        try {
            response = new NettyResponse(httpResponse);
            value = this.responseHandler.handle(this.request, response);
        }
        finally {
            Duration responseProcessingTime = Duration.nanosSince(responseStart);
            Duration requestProcessingTime = new Duration(responseStart - this.requestStart, TimeUnit.NANOSECONDS);
            if (response != null) {
                this.stats.record(this.request.getMethod(), response.getStatusCode(), response.getBytesRead(), response.getBytesRead(), requestProcessingTime, responseProcessingTime);
            }
        }
        return value;
    }

    protected void failed(Throwable throwable) {
        if (this.state.get() == NettyAsyncHttpState.CANCELED) {
            return;
        }
        if (throwable instanceof Exception) {
            try {
                T value = this.responseHandler.handleException(this.request, (Exception)throwable);
                this.state.set(NettyAsyncHttpState.DONE);
                this.set(value);
                return;
            }
            catch (Throwable newThrowable) {
                throwable = newThrowable;
            }
        }
        this.storeException(throwable);
    }

    private void storeException(Throwable throwable) {
        if (throwable instanceof CancellationException) {
            this.state.set(NettyAsyncHttpState.CANCELED);
        } else {
            this.state.set(NettyAsyncHttpState.FAILED);
        }
        if (throwable == null) {
            throwable = new Throwable("Throwable is null");
            log.error(throwable, "Something is broken");
        }
        this.setException(throwable);
    }

    public String toString() {
        return Objects.toStringHelper(this).add("requestStart", this.requestStart).add("state", this.state).add("request", this.request).toString();
    }

    public static enum NettyAsyncHttpState {
        WAITING_FOR_CONNECTION,
        SENDING_REQUEST,
        WAITING_FOR_RESPONSE,
        PROCESSING_RESPONSE,
        DONE,
        FAILED,
        CANCELED;

    }
}

