/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.airlift.http.client.netty.socks;

import com.facebook.presto.jdbc.internal.airlift.http.client.netty.socks.SettableChannelFuture;
import com.facebook.presto.jdbc.internal.airlift.http.client.netty.socks.Socks4HandshakeHandler;
import com.facebook.presto.jdbc.internal.airlift.http.client.netty.socks.SocksProtocols;
import com.facebook.presto.jdbc.internal.guava.net.HostAndPort;
import com.facebook.presto.jdbc.internal.netty.bootstrap.ClientBootstrap;
import com.facebook.presto.jdbc.internal.netty.buffer.ChannelBuffer;
import com.facebook.presto.jdbc.internal.netty.channel.Channel;
import com.facebook.presto.jdbc.internal.netty.channel.ChannelFactory;
import com.facebook.presto.jdbc.internal.netty.channel.ChannelFuture;
import com.facebook.presto.jdbc.internal.netty.channel.ChannelFutureListener;
import com.facebook.presto.jdbc.internal.netty.channel.ChannelPipeline;
import com.facebook.presto.jdbc.internal.netty.channel.ChannelPipelineFactory;
import com.facebook.presto.jdbc.internal.netty.channel.Channels;
import com.facebook.presto.jdbc.internal.netty.handler.codec.frame.FixedLengthFrameDecoder;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public class Socks4ClientBootstrap
extends ClientBootstrap {
    static final String FRAME_DECODER = "frameDecoder";
    static final String HANDSHAKE = "handshake";
    private final HostAndPort socksProxyAddr;

    public Socks4ClientBootstrap(ChannelFactory channelFactory, HostAndPort socksProxyAddr) {
        super(channelFactory);
        this.socksProxyAddr = socksProxyAddr;
    }

    @Override
    public ChannelPipelineFactory getPipelineFactory() {
        return new ChannelPipelineFactory(){

            @Override
            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline cp = Channels.pipeline();
                cp.addLast(Socks4ClientBootstrap.FRAME_DECODER, new FixedLengthFrameDecoder(8));
                cp.addLast(Socks4ClientBootstrap.HANDSHAKE, new Socks4HandshakeHandler(Socks4ClientBootstrap.super.getPipelineFactory()));
                return cp;
            }
        };
    }

    @Override
    public ChannelFuture connect(final SocketAddress remoteAddress) {
        if (!(remoteAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("expecting InetSocketAddress");
        }
        final SettableChannelFuture settableChannelFuture = new SettableChannelFuture();
        super.connect(new InetSocketAddress(this.socksProxyAddr.getHostText(), this.socksProxyAddr.getPort())).addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                settableChannelFuture.setChannel(future.getChannel());
                if (future.isSuccess()) {
                    Socks4ClientBootstrap.this.socksConnect(future.getChannel(), (InetSocketAddress)remoteAddress).addListener(new ChannelFutureListener(){

                        @Override
                        public void operationComplete(ChannelFuture innerFuture) throws Exception {
                            if (innerFuture.isSuccess()) {
                                settableChannelFuture.setSuccess();
                            } else {
                                settableChannelFuture.setFailure(innerFuture.getCause());
                            }
                        }
                    });
                } else {
                    settableChannelFuture.setFailure(future.getCause());
                }
            }
        });
        return settableChannelFuture;
    }

    private ChannelFuture socksConnect(Channel channel, InetSocketAddress remoteAddress) {
        ChannelBuffer handshake = null;
        if (remoteAddress.getAddress() == null && remoteAddress.getHostName() != null || remoteAddress.getHostName().equals("localhost")) {
            handshake = SocksProtocols.createSock4aPacket(remoteAddress.getHostName(), remoteAddress.getPort());
        }
        if (remoteAddress.getAddress() != null) {
            handshake = SocksProtocols.createSocks4packet(remoteAddress.getAddress(), remoteAddress.getPort());
        }
        if (handshake == null) {
            throw new IllegalArgumentException("Invalid Address " + remoteAddress);
        }
        channel.write(handshake);
        return ((Socks4HandshakeHandler)channel.getPipeline().get(HANDSHAKE)).getChannelFuture();
    }
}

