/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.airlift.http.client.netty.socks;

import com.facebook.presto.jdbc.internal.airlift.http.client.netty.socks.SettableChannelFuture;
import com.facebook.presto.jdbc.internal.netty.buffer.ChannelBuffer;
import com.facebook.presto.jdbc.internal.netty.channel.ChannelHandlerContext;
import com.facebook.presto.jdbc.internal.netty.channel.ChannelPipeline;
import com.facebook.presto.jdbc.internal.netty.channel.ChannelPipelineFactory;
import com.facebook.presto.jdbc.internal.netty.channel.ExceptionEvent;
import com.facebook.presto.jdbc.internal.netty.channel.MessageEvent;
import com.facebook.presto.jdbc.internal.netty.channel.SimpleChannelHandler;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public class Socks4HandshakeHandler
extends SimpleChannelHandler {
    private final SettableChannelFuture channelFuture = new SettableChannelFuture();
    private final ChannelPipelineFactory delegate;

    public Socks4HandshakeHandler(ChannelPipelineFactory delegate) {
        this.delegate = delegate;
    }

    public SettableChannelFuture getChannelFuture() {
        return this.channelFuture;
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        this.channelFuture.setChannel(ctx.getChannel());
        if (e.getMessage() instanceof ChannelBuffer) {
            ChannelBuffer msg = (ChannelBuffer)e.getMessage();
            if (msg.readableBytes() < 8) {
                this.channelFuture.setFailure(new IOException("invalid sock server reply length = " + msg.readableBytes()));
            }
            msg.readByte();
            byte status = msg.readByte();
            short port = msg.readShort();
            byte[] addr = new byte[4];
            msg.readBytes(addr);
            ctx.getChannel().setAttachment(new InetSocketAddress(InetAddress.getByAddress(addr), (int)port));
            if (status == 90) {
                ctx.getPipeline().remove("frameDecoder");
                ctx.getPipeline().remove("handshake");
                ChannelPipeline delegatePipeline = this.delegate.getPipeline();
                for (String name : delegatePipeline.getNames()) {
                    ctx.getPipeline().addLast(name, delegatePipeline.get(name));
                }
                this.channelFuture.setSuccess();
            } else {
                this.channelFuture.setFailure(new IOException("sock server reply failure code :" + Integer.toHexString(status)));
            }
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        this.channelFuture.setChannel(ctx.getChannel());
        this.channelFuture.setFailure(e.getCause());
    }
}

