/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.airlift.http.client.netty.socks;

import com.facebook.presto.jdbc.internal.guava.base.Charsets;
import com.facebook.presto.jdbc.internal.netty.buffer.ChannelBuffer;
import com.facebook.presto.jdbc.internal.netty.buffer.ChannelBuffers;
import java.net.InetAddress;

public class SocksProtocols {
    public static final int SOCKS_VERSION_4 = 4;
    public static final int CONNECT = 1;
    public static final int REQUEST_GRANTED = 90;
    public static final int REQUEST_FAILED = 91;
    public static final int REQUEST_FAILED_NO_IDENTD = 92;
    public static final int REQUEST_FAILED_USERID_NOT_CONFIRMED = 93;

    public static ChannelBuffer createSocks4packet(InetAddress address, int port) {
        if (address == null) {
            throw new IllegalArgumentException("address is null");
        }
        byte[] userBytes = System.getProperty("user.name", "").getBytes(Charsets.UTF_8);
        ChannelBuffer handshake = ChannelBuffers.dynamicBuffer(9 + userBytes.length);
        handshake.writeByte(4);
        handshake.writeByte(1);
        handshake.writeShort(port);
        handshake.writeBytes(address.getAddress());
        handshake.writeBytes(userBytes);
        handshake.writeByte(0);
        return handshake;
    }

    public static ChannelBuffer createSock4aPacket(String hostName, int port) {
        if (hostName == null) {
            throw new IllegalArgumentException("hostName is null");
        }
        byte[] userBytes = System.getProperty("user.name", "").getBytes(Charsets.UTF_8);
        byte[] hostNameBytes = hostName.getBytes(Charsets.UTF_8);
        ChannelBuffer handshake = ChannelBuffers.dynamicBuffer(10 + userBytes.length + hostNameBytes.length);
        handshake.writeByte(4);
        handshake.writeByte(1);
        handshake.writeShort(port);
        handshake.writeByte(0);
        handshake.writeByte(0);
        handshake.writeByte(0);
        handshake.writeByte(1);
        handshake.writeBytes(userBytes);
        handshake.writeByte(0);
        handshake.writeBytes(hostNameBytes);
        handshake.writeByte(0);
        return handshake;
    }
}

