/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.airlift.http.client.testing;

import com.facebook.presto.jdbc.internal.airlift.http.client.AsyncHttpClient;
import com.facebook.presto.jdbc.internal.airlift.http.client.Request;
import com.facebook.presto.jdbc.internal.airlift.http.client.RequestStats;
import com.facebook.presto.jdbc.internal.airlift.http.client.Response;
import com.facebook.presto.jdbc.internal.airlift.http.client.ResponseHandler;
import com.facebook.presto.jdbc.internal.airlift.units.Duration;
import com.facebook.presto.jdbc.internal.guava.base.Function;
import com.facebook.presto.jdbc.internal.guava.base.Preconditions;
import com.facebook.presto.jdbc.internal.guava.util.concurrent.ForwardingListenableFuture;
import com.facebook.presto.jdbc.internal.guava.util.concurrent.ListenableFuture;
import com.facebook.presto.jdbc.internal.guava.util.concurrent.ListeningExecutorService;
import com.facebook.presto.jdbc.internal.guava.util.concurrent.MoreExecutors;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class TestingHttpClient
implements AsyncHttpClient {
    private final Function<Request, Response> processor;
    private final ListeningExecutorService executor;
    private final RequestStats stats = new RequestStats();
    private final AtomicBoolean closed = new AtomicBoolean();

    public TestingHttpClient(Function<Request, Response> processor) {
        this(processor, MoreExecutors.sameThreadExecutor());
    }

    public TestingHttpClient(Function<Request, Response> processor, ExecutorService executor) {
        this.processor = processor;
        this.executor = MoreExecutors.listeningDecorator(executor);
    }

    @Override
    public <T, E extends Exception> AsyncHttpClient.AsyncHttpResponseFuture<T> executeAsync(final Request request, final ResponseHandler<T, E> responseHandler) {
        Preconditions.checkNotNull(request, "request is null");
        Preconditions.checkNotNull(responseHandler, "responseHandler is null");
        Preconditions.checkState(!this.closed.get(), "client is closed");
        final AtomicReference<String> state = new AtomicReference<String>("SENDING_REQUEST");
        ListenableFuture future = this.executor.submit(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return TestingHttpClient.this.execute(request, responseHandler, state);
            }
        });
        return new TestingAsyncHttpResponseFuture(future, state);
    }

    @Override
    public <T, E extends Exception> T execute(Request request, ResponseHandler<T, E> responseHandler) throws E {
        Preconditions.checkNotNull(request, "request is null");
        Preconditions.checkNotNull(responseHandler, "responseHandler is null");
        Preconditions.checkState(!this.closed.get(), "client is closed");
        return this.execute(request, responseHandler, new AtomicReference<String>("SENDING_REQUEST"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, E extends Exception> T execute(Request request, ResponseHandler<T, E> responseHandler, AtomicReference<String> state) throws E {
        Response response;
        state.set("PROCESSING_REQUEST");
        Duration requestProcessingTime = null;
        try {
            long requestStart = System.nanoTime();
            response = this.processor.apply(request);
            requestProcessingTime = Duration.nanosSince(requestStart);
        }
        catch (Throwable e) {
            state.set("FAILED");
            this.stats.record(request.getMethod(), 0, 0L, 0L, requestProcessingTime, null);
            if (e instanceof Exception) {
                return responseHandler.handleException(request, (Exception)e);
            }
            throw e;
        }
        Preconditions.checkState(response != null, "response is null");
        state.set("PROCESSING_RESPONSE");
        long responseStart = System.nanoTime();
        try {
            T t = responseHandler.handle(request, response);
            return t;
        }
        finally {
            state.set("DONE");
            Duration responseProcessingTime = Duration.nanosSince(responseStart);
            this.stats.record(request.getMethod(), response.getStatusCode(), response.getBytesRead(), response.getBytesRead(), requestProcessingTime, responseProcessingTime);
        }
    }

    @Override
    public RequestStats getStats() {
        return this.stats;
    }

    @Override
    public void close() {
        this.closed.set(true);
    }

    private class TestingAsyncHttpResponseFuture<T>
    extends ForwardingListenableFuture<T>
    implements AsyncHttpClient.AsyncHttpResponseFuture<T> {
        private final AtomicReference<String> state;
        private final ListenableFuture<T> future;

        private TestingAsyncHttpResponseFuture(ListenableFuture<T> future, AtomicReference<String> state) {
            this.future = future;
            this.state = state;
        }

        @Override
        protected ListenableFuture<T> delegate() {
            return this.future;
        }

        @Override
        public String getState() {
            return this.state.get();
        }
    }
}

