/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.client;

import com.facebook.presto.jdbc.internal.client.ErrorLocation;
import com.facebook.presto.jdbc.internal.client.Failure;
import com.facebook.presto.jdbc.internal.guava.base.Preconditions;
import com.facebook.presto.jdbc.internal.guava.collect.ImmutableCollection;
import com.facebook.presto.jdbc.internal.guava.collect.ImmutableList;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.validation.constraints.NotNull;

@Immutable
public class FailureInfo {
    private static final Pattern STACK_TRACE_PATTERN = Pattern.compile("(.*)\\.(.*)\\(([^:]*)(?::(.*))?\\)");
    private final String type;
    private final String message;
    private final FailureInfo cause;
    private final List<FailureInfo> suppressed;
    private final List<String> stack;
    private final ErrorLocation errorLocation;

    @JsonCreator
    public FailureInfo(@JsonProperty(value="type") String type, @JsonProperty(value="message") String message, @JsonProperty(value="cause") FailureInfo cause, @JsonProperty(value="suppressed") List<FailureInfo> suppressed, @JsonProperty(value="stack") List<String> stack, @JsonProperty(value="errorLocation") @Nullable ErrorLocation errorLocation) {
        Preconditions.checkNotNull(type, "type is null");
        Preconditions.checkNotNull(suppressed, "suppressed is null");
        Preconditions.checkNotNull(stack, "stack is null");
        this.type = type;
        this.message = message;
        this.cause = cause;
        this.suppressed = ImmutableList.copyOf(suppressed);
        this.stack = ImmutableList.copyOf(stack);
        this.errorLocation = errorLocation;
    }

    @NotNull
    @JsonProperty
    public String getType() {
        return this.type;
    }

    @Nullable
    @JsonProperty
    public String getMessage() {
        return this.message;
    }

    @Nullable
    @JsonProperty
    public FailureInfo getCause() {
        return this.cause;
    }

    @NotNull
    @JsonProperty
    public List<FailureInfo> getSuppressed() {
        return this.suppressed;
    }

    @NotNull
    @JsonProperty
    public List<String> getStack() {
        return this.stack;
    }

    @Nullable
    @JsonProperty
    public ErrorLocation getErrorLocation() {
        return this.errorLocation;
    }

    public RuntimeException toException() {
        return FailureInfo.toException(this);
    }

    private static Failure toException(FailureInfo failureInfo) {
        if (failureInfo == null) {
            return null;
        }
        Failure failure = new Failure(failureInfo.getType(), failureInfo.getMessage(), FailureInfo.toException(failureInfo.getCause()));
        for (FailureInfo suppressed : failureInfo.getSuppressed()) {
            failure.addSuppressed(FailureInfo.toException(suppressed));
        }
        ImmutableList.Builder stackTraceBuilder = ImmutableList.builder();
        for (String stack : failureInfo.getStack()) {
            stackTraceBuilder.add(FailureInfo.toStackTraceElement(stack));
        }
        ImmutableCollection stackTrace = stackTraceBuilder.build();
        failure.setStackTrace(stackTrace.toArray(new StackTraceElement[stackTrace.size()]));
        return failure;
    }

    public static StackTraceElement toStackTraceElement(String stack) {
        Matcher matcher = STACK_TRACE_PATTERN.matcher(stack);
        if (matcher.matches()) {
            String declaringClass = matcher.group(1);
            String methodName = matcher.group(2);
            String fileName = matcher.group(3);
            int number = -1;
            if (fileName.equals("Native Method")) {
                fileName = null;
                number = -2;
            } else if (matcher.group(4) != null) {
                number = Integer.parseInt(matcher.group(4));
            }
            return new StackTraceElement(declaringClass, methodName, fileName, number);
        }
        return new StackTraceElement("Unknown", stack, null, -1);
    }
}

