/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.netty.bootstrap;

import com.facebook.presto.jdbc.internal.netty.bootstrap.Bootstrap;
import com.facebook.presto.jdbc.internal.netty.channel.Channel;
import com.facebook.presto.jdbc.internal.netty.channel.ChannelException;
import com.facebook.presto.jdbc.internal.netty.channel.ChannelFactory;
import com.facebook.presto.jdbc.internal.netty.channel.ChannelFuture;
import com.facebook.presto.jdbc.internal.netty.channel.ChannelPipeline;
import com.facebook.presto.jdbc.internal.netty.channel.ChannelPipelineException;
import java.net.SocketAddress;

public class ConnectionlessBootstrap
extends Bootstrap {
    public ConnectionlessBootstrap() {
    }

    public ConnectionlessBootstrap(ChannelFactory channelFactory) {
        super(channelFactory);
    }

    public Channel bind() {
        SocketAddress localAddress = (SocketAddress)this.getOption("localAddress");
        if (localAddress == null) {
            throw new IllegalStateException("localAddress option is not set.");
        }
        return this.bind(localAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel bind(SocketAddress localAddress) {
        Channel ch;
        block7: {
            ChannelPipeline pipeline;
            if (localAddress == null) {
                throw new NullPointerException("localAddress");
            }
            try {
                pipeline = this.getPipelineFactory().getPipeline();
            }
            catch (Exception e) {
                throw new ChannelPipelineException("Failed to initialize a pipeline.", e);
            }
            ch = this.getFactory().newChannel(pipeline);
            boolean success = false;
            try {
                ch.getConfig().setOptions(this.getOptions());
                success = true;
                Object var6_6 = null;
                if (success) break block7;
                ch.close();
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (!success) {
                    ch.close();
                }
                throw throwable;
            }
            {
            }
        }
        ChannelFuture future = ch.bind(localAddress);
        future.awaitUninterruptibly();
        if (!future.isSuccess()) {
            future.getChannel().close().awaitUninterruptibly();
            throw new ChannelException("Failed to bind to: " + localAddress, future.getCause());
        }
        return ch;
    }

    public ChannelFuture connect() {
        SocketAddress remoteAddress = (SocketAddress)this.getOption("remoteAddress");
        if (remoteAddress == null) {
            throw new IllegalStateException("remoteAddress option is not set.");
        }
        return this.connect(remoteAddress);
    }

    public ChannelFuture connect(SocketAddress remoteAddress) {
        if (remoteAddress == null) {
            throw new NullPointerException("remotedAddress");
        }
        SocketAddress localAddress = (SocketAddress)this.getOption("localAddress");
        return this.connect(remoteAddress, localAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress) {
        Channel ch;
        block7: {
            ChannelPipeline pipeline;
            if (remoteAddress == null) {
                throw new NullPointerException("remoteAddress");
            }
            try {
                pipeline = this.getPipelineFactory().getPipeline();
            }
            catch (Exception e) {
                throw new ChannelPipelineException("Failed to initialize a pipeline.", e);
            }
            ch = this.getFactory().newChannel(pipeline);
            boolean success = false;
            try {
                ch.getConfig().setOptions(this.getOptions());
                success = true;
                Object var7_7 = null;
                if (success) break block7;
                ch.close();
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (!success) {
                    ch.close();
                }
                throw throwable;
            }
            {
            }
        }
        if (localAddress != null) {
            ch.bind(localAddress);
        }
        return ch.connect(remoteAddress);
    }
}

