/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.netty.buffer;

import com.facebook.presto.jdbc.internal.netty.buffer.AbstractChannelBuffer;
import com.facebook.presto.jdbc.internal.netty.buffer.ChannelBuffer;
import com.facebook.presto.jdbc.internal.netty.buffer.ChannelBufferFactory;
import com.facebook.presto.jdbc.internal.netty.buffer.ChannelBuffers;
import com.facebook.presto.jdbc.internal.netty.buffer.HeapChannelBufferFactory;
import com.facebook.presto.jdbc.internal.netty.util.internal.DetectionUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeChannelBuffer
extends AbstractChannelBuffer {
    private final ByteOrder order;
    private ChannelBuffer[] components;
    private int[] indices;
    private int lastAccessedComponentId;
    private final boolean gathering;

    public CompositeChannelBuffer(ByteOrder endianness, List<ChannelBuffer> buffers, boolean gathering) {
        this.order = endianness;
        this.gathering = gathering;
        this.setComponents(buffers);
    }

    public boolean useGathering() {
        return this.gathering && DetectionUtil.javaVersion() >= 7;
    }

    public List<ChannelBuffer> decompose(int index, int length) {
        int readableBytes;
        if (length == 0) {
            return Collections.emptyList();
        }
        if (index + length > this.capacity()) {
            throw new IndexOutOfBoundsException("Too many bytes to decompose - Need " + (index + length) + ", capacity is " + this.capacity());
        }
        int componentId = this.componentId(index);
        ArrayList<ChannelBuffer> slice = new ArrayList<ChannelBuffer>(this.components.length);
        ChannelBuffer first = this.components[componentId].duplicate();
        first.readerIndex(index - this.indices[componentId]);
        ChannelBuffer buf = first;
        int bytesToSlice = length;
        do {
            if (bytesToSlice <= (readableBytes = buf.readableBytes())) {
                buf.writerIndex(buf.readerIndex() + bytesToSlice);
                slice.add(buf);
                break;
            }
            slice.add(buf);
            buf = this.components[++componentId].duplicate();
        } while ((bytesToSlice -= readableBytes) > 0);
        for (int i = 0; i < slice.size(); ++i) {
            slice.set(i, ((ChannelBuffer)slice.get(i)).slice());
        }
        return slice;
    }

    private void setComponents(List<ChannelBuffer> newComponents) {
        int i;
        assert (!newComponents.isEmpty());
        this.lastAccessedComponentId = 0;
        this.components = new ChannelBuffer[newComponents.size()];
        for (i = 0; i < this.components.length; ++i) {
            ChannelBuffer c = newComponents.get(i);
            if (c.order() != this.order()) {
                throw new IllegalArgumentException("All buffers must have the same endianness.");
            }
            assert (c.readerIndex() == 0);
            assert (c.writerIndex() == c.capacity());
            this.components[i] = c;
        }
        this.indices = new int[this.components.length + 1];
        this.indices[0] = 0;
        for (i = 1; i <= this.components.length; ++i) {
            this.indices[i] = this.indices[i - 1] + this.components[i - 1].capacity();
        }
        this.setIndex(0, this.capacity());
    }

    private CompositeChannelBuffer(CompositeChannelBuffer buffer) {
        this.order = buffer.order;
        this.gathering = buffer.gathering;
        this.components = (ChannelBuffer[])buffer.components.clone();
        this.indices = (int[])buffer.indices.clone();
        this.setIndex(buffer.readerIndex(), buffer.writerIndex());
    }

    @Override
    public ChannelBufferFactory factory() {
        return HeapChannelBufferFactory.getInstance(this.order());
    }

    @Override
    public ByteOrder order() {
        return this.order;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public boolean hasArray() {
        return false;
    }

    @Override
    public byte[] array() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int arrayOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int capacity() {
        return this.indices[this.components.length];
    }

    public int numComponents() {
        return this.components.length;
    }

    @Override
    public byte getByte(int index) {
        int componentId = this.componentId(index);
        return this.components[componentId].getByte(index - this.indices[componentId]);
    }

    @Override
    public short getShort(int index) {
        int componentId = this.componentId(index);
        if (index + 2 <= this.indices[componentId + 1]) {
            return this.components[componentId].getShort(index - this.indices[componentId]);
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return (short)((this.getByte(index) & 0xFF) << 8 | this.getByte(index + 1) & 0xFF);
        }
        return (short)(this.getByte(index) & 0xFF | (this.getByte(index + 1) & 0xFF) << 8);
    }

    @Override
    public int getUnsignedMedium(int index) {
        int componentId = this.componentId(index);
        if (index + 3 <= this.indices[componentId + 1]) {
            return this.components[componentId].getUnsignedMedium(index - this.indices[componentId]);
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return (this.getShort(index) & 0xFFFF) << 8 | this.getByte(index + 2) & 0xFF;
        }
        return this.getShort(index) & 0xFFFF | (this.getByte(index + 2) & 0xFF) << 16;
    }

    @Override
    public int getInt(int index) {
        int componentId = this.componentId(index);
        if (index + 4 <= this.indices[componentId + 1]) {
            return this.components[componentId].getInt(index - this.indices[componentId]);
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return (this.getShort(index) & 0xFFFF) << 16 | this.getShort(index + 2) & 0xFFFF;
        }
        return this.getShort(index) & 0xFFFF | (this.getShort(index + 2) & 0xFFFF) << 16;
    }

    @Override
    public long getLong(int index) {
        int componentId = this.componentId(index);
        if (index + 8 <= this.indices[componentId + 1]) {
            return this.components[componentId].getLong(index - this.indices[componentId]);
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return ((long)this.getInt(index) & 0xFFFFFFFFL) << 32 | (long)this.getInt(index + 4) & 0xFFFFFFFFL;
        }
        return (long)this.getInt(index) & 0xFFFFFFFFL | ((long)this.getInt(index + 4) & 0xFFFFFFFFL) << 32;
    }

    @Override
    public void getBytes(int index, byte[] dst, int dstIndex, int length) {
        int componentId;
        if (index > this.capacity() - length || dstIndex > dst.length - length) {
            throw new IndexOutOfBoundsException("Too many bytes to read - Needs " + (index + length) + ", maximum is " + this.capacity() + " or " + dst.length);
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index must be >= 0");
        }
        if (length == 0) {
            return;
        }
        int i = componentId = this.componentId(index);
        while (length > 0) {
            ChannelBuffer s = this.components[i];
            int adjustment = this.indices[i];
            int localLength = Math.min(length, s.capacity() - (index - adjustment));
            s.getBytes(index - adjustment, dst, dstIndex, localLength);
            index += localLength;
            dstIndex += localLength;
            length -= localLength;
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getBytes(int index, ByteBuffer dst) {
        int componentId = this.componentId(index);
        int limit = dst.limit();
        int length = dst.remaining();
        if (index > this.capacity() - length) {
            throw new IndexOutOfBoundsException("Too many bytes to be read - Needs " + (index + length) + ", maximum is " + this.capacity());
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index must be >= 0");
        }
        int i = componentId;
        try {
            while (length > 0) {
                ChannelBuffer s = this.components[i];
                int adjustment = this.indices[i];
                int localLength = Math.min(length, s.capacity() - (index - adjustment));
                dst.limit(dst.position() + localLength);
                s.getBytes(index - adjustment, dst);
                index += localLength;
                length -= localLength;
                ++i;
            }
            Object var11_10 = null;
            dst.limit(limit);
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            dst.limit(limit);
            throw throwable;
        }
    }

    @Override
    public void getBytes(int index, ChannelBuffer dst, int dstIndex, int length) {
        if (index > this.capacity() - length || dstIndex > dst.capacity() - length) {
            throw new IndexOutOfBoundsException("Too many bytes to be read - Needs " + (index + length) + " or " + (dstIndex + length) + ", maximum is " + this.capacity() + " or " + dst.capacity());
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index must be >= 0");
        }
        if (length == 0) {
            return;
        }
        int i = this.componentId(index);
        while (length > 0) {
            ChannelBuffer s = this.components[i];
            int adjustment = this.indices[i];
            int localLength = Math.min(length, s.capacity() - (index - adjustment));
            s.getBytes(index - adjustment, dst, dstIndex, localLength);
            index += localLength;
            dstIndex += localLength;
            length -= localLength;
            ++i;
        }
    }

    @Override
    public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        if (this.useGathering()) {
            return (int)out.write(this.toByteBuffers(index, length));
        }
        return out.write(this.toByteBuffer(index, length));
    }

    @Override
    public void getBytes(int index, OutputStream out, int length) throws IOException {
        if (index > this.capacity() - length) {
            throw new IndexOutOfBoundsException("Too many bytes to be read - needs " + (index + length) + ", maximum of " + this.capacity());
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index must be >= 0");
        }
        if (length == 0) {
            return;
        }
        int i = this.componentId(index);
        while (length > 0) {
            ChannelBuffer s = this.components[i];
            int adjustment = this.indices[i];
            int localLength = Math.min(length, s.capacity() - (index - adjustment));
            s.getBytes(index - adjustment, out, localLength);
            index += localLength;
            length -= localLength;
            ++i;
        }
    }

    @Override
    public void setByte(int index, int value) {
        int componentId = this.componentId(index);
        this.components[componentId].setByte(index - this.indices[componentId], value);
    }

    @Override
    public void setShort(int index, int value) {
        int componentId = this.componentId(index);
        if (index + 2 <= this.indices[componentId + 1]) {
            this.components[componentId].setShort(index - this.indices[componentId], value);
        } else if (this.order() == ByteOrder.BIG_ENDIAN) {
            this.setByte(index, (byte)(value >>> 8));
            this.setByte(index + 1, (byte)value);
        } else {
            this.setByte(index, (byte)value);
            this.setByte(index + 1, (byte)(value >>> 8));
        }
    }

    @Override
    public void setMedium(int index, int value) {
        int componentId = this.componentId(index);
        if (index + 3 <= this.indices[componentId + 1]) {
            this.components[componentId].setMedium(index - this.indices[componentId], value);
        } else if (this.order() == ByteOrder.BIG_ENDIAN) {
            this.setShort(index, (short)(value >> 8));
            this.setByte(index + 2, (byte)value);
        } else {
            this.setShort(index, (short)value);
            this.setByte(index + 2, (byte)(value >>> 16));
        }
    }

    @Override
    public void setInt(int index, int value) {
        int componentId = this.componentId(index);
        if (index + 4 <= this.indices[componentId + 1]) {
            this.components[componentId].setInt(index - this.indices[componentId], value);
        } else if (this.order() == ByteOrder.BIG_ENDIAN) {
            this.setShort(index, (short)(value >>> 16));
            this.setShort(index + 2, (short)value);
        } else {
            this.setShort(index, (short)value);
            this.setShort(index + 2, (short)(value >>> 16));
        }
    }

    @Override
    public void setLong(int index, long value) {
        int componentId = this.componentId(index);
        if (index + 8 <= this.indices[componentId + 1]) {
            this.components[componentId].setLong(index - this.indices[componentId], value);
        } else if (this.order() == ByteOrder.BIG_ENDIAN) {
            this.setInt(index, (int)(value >>> 32));
            this.setInt(index + 4, (int)value);
        } else {
            this.setInt(index, (int)value);
            this.setInt(index + 4, (int)(value >>> 32));
        }
    }

    @Override
    public void setBytes(int index, byte[] src, int srcIndex, int length) {
        int componentId = this.componentId(index);
        if (index > this.capacity() - length || srcIndex > src.length - length) {
            throw new IndexOutOfBoundsException("Too many bytes to read - needs " + (index + length) + " or " + (srcIndex + length) + ", maximum is " + this.capacity() + " or " + src.length);
        }
        int i = componentId;
        while (length > 0) {
            ChannelBuffer s = this.components[i];
            int adjustment = this.indices[i];
            int localLength = Math.min(length, s.capacity() - (index - adjustment));
            s.setBytes(index - adjustment, src, srcIndex, localLength);
            index += localLength;
            srcIndex += localLength;
            length -= localLength;
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBytes(int index, ByteBuffer src) {
        int componentId = this.componentId(index);
        int limit = src.limit();
        int length = src.remaining();
        if (index > this.capacity() - length) {
            throw new IndexOutOfBoundsException("Too many bytes to be written - Needs " + (index + length) + ", maximum is " + this.capacity());
        }
        int i = componentId;
        try {
            while (length > 0) {
                ChannelBuffer s = this.components[i];
                int adjustment = this.indices[i];
                int localLength = Math.min(length, s.capacity() - (index - adjustment));
                src.limit(src.position() + localLength);
                s.setBytes(index - adjustment, src);
                index += localLength;
                length -= localLength;
                ++i;
            }
            Object var11_10 = null;
            src.limit(limit);
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            src.limit(limit);
            throw throwable;
        }
    }

    @Override
    public void setBytes(int index, ChannelBuffer src, int srcIndex, int length) {
        int componentId = this.componentId(index);
        if (index > this.capacity() - length || srcIndex > src.capacity() - length) {
            throw new IndexOutOfBoundsException("Too many bytes to be written - Needs " + (index + length) + " or " + (srcIndex + length) + ", maximum is " + this.capacity() + " or " + src.capacity());
        }
        int i = componentId;
        while (length > 0) {
            ChannelBuffer s = this.components[i];
            int adjustment = this.indices[i];
            int localLength = Math.min(length, s.capacity() - (index - adjustment));
            s.setBytes(index - adjustment, src, srcIndex, localLength);
            index += localLength;
            srcIndex += localLength;
            length -= localLength;
            ++i;
        }
    }

    @Override
    public int setBytes(int index, InputStream in, int length) throws IOException {
        int componentId = this.componentId(index);
        if (index > this.capacity() - length) {
            throw new IndexOutOfBoundsException("Too many bytes to write - Needs " + (index + length) + ", maximum is " + this.capacity());
        }
        int i = componentId;
        int readBytes = 0;
        do {
            int localLength;
            int adjustment;
            ChannelBuffer s;
            int localReadBytes;
            if ((localReadBytes = (s = this.components[i]).setBytes(index - (adjustment = this.indices[i]), in, localLength = Math.min(length, s.capacity() - (index - adjustment)))) < 0) {
                if (readBytes != 0) break;
                return -1;
            }
            if (localReadBytes == localLength) {
                index += localLength;
                length -= localLength;
                readBytes += localLength;
                ++i;
                continue;
            }
            index += localReadBytes;
            length -= localReadBytes;
            readBytes += localReadBytes;
        } while (length > 0);
        return readBytes;
    }

    @Override
    public int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
        int localLength;
        int adjustment;
        ChannelBuffer s;
        int localReadBytes;
        int componentId = this.componentId(index);
        if (index > this.capacity() - length) {
            throw new IndexOutOfBoundsException("Too many bytes to write - Needs " + (index + length) + ", maximum is " + this.capacity());
        }
        int i = componentId;
        int readBytes = 0;
        while ((localReadBytes = (s = this.components[i]).setBytes(index - (adjustment = this.indices[i]), in, localLength = Math.min(length, s.capacity() - (index - adjustment)))) != 0) {
            if (localReadBytes < 0) {
                if (readBytes != 0) break;
                return -1;
            }
            if (localReadBytes == localLength) {
                index += localLength;
                length -= localLength;
                readBytes += localLength;
                ++i;
            } else {
                index += localReadBytes;
                length -= localReadBytes;
                readBytes += localReadBytes;
            }
            if (length > 0) continue;
        }
        return readBytes;
    }

    @Override
    public ChannelBuffer duplicate() {
        CompositeChannelBuffer duplicate = new CompositeChannelBuffer(this);
        duplicate.setIndex(this.readerIndex(), this.writerIndex());
        return duplicate;
    }

    @Override
    public ChannelBuffer copy(int index, int length) {
        int componentId = this.componentId(index);
        if (index > this.capacity() - length) {
            throw new IndexOutOfBoundsException("Too many bytes to copy - Needs " + (index + length) + ", maximum is " + this.capacity());
        }
        ChannelBuffer dst = this.factory().getBuffer(this.order(), length);
        this.copyTo(index, length, componentId, dst);
        return dst;
    }

    private void copyTo(int index, int length, int componentId, ChannelBuffer dst) {
        int dstIndex = 0;
        int i = componentId;
        while (length > 0) {
            ChannelBuffer s = this.components[i];
            int adjustment = this.indices[i];
            int localLength = Math.min(length, s.capacity() - (index - adjustment));
            s.getBytes(index - adjustment, dst, dstIndex, localLength);
            index += localLength;
            dstIndex += localLength;
            length -= localLength;
            ++i;
        }
        dst.writerIndex(dst.capacity());
    }

    public ChannelBuffer getBuffer(int index) {
        if (index < 0 || index >= this.capacity()) {
            throw new IndexOutOfBoundsException("Invalid index: " + index + " - Bytes needed: " + index + ", maximum is " + this.capacity());
        }
        return this.components[this.componentId(index)];
    }

    @Override
    public ChannelBuffer slice(int index, int length) {
        if (index == 0) {
            if (length == 0) {
                return ChannelBuffers.EMPTY_BUFFER;
            }
        } else {
            if (index < 0 || index > this.capacity() - length) {
                throw new IndexOutOfBoundsException("Invalid index: " + index + " - Bytes needed: " + (index + length) + ", maximum is " + this.capacity());
            }
            if (length == 0) {
                return ChannelBuffers.EMPTY_BUFFER;
            }
        }
        List<ChannelBuffer> components = this.decompose(index, length);
        switch (components.size()) {
            case 0: {
                return ChannelBuffers.EMPTY_BUFFER;
            }
            case 1: {
                return components.get(0);
            }
        }
        return new CompositeChannelBuffer(this.order(), components, this.gathering);
    }

    @Override
    public ByteBuffer toByteBuffer(int index, int length) {
        if (this.components.length == 1) {
            return this.components[0].toByteBuffer(index, length);
        }
        ByteBuffer[] buffers = this.toByteBuffers(index, length);
        ByteBuffer merged = ByteBuffer.allocate(length).order(this.order());
        for (ByteBuffer b : buffers) {
            merged.put(b);
        }
        merged.flip();
        return merged;
    }

    @Override
    public ByteBuffer[] toByteBuffers(int index, int length) {
        if (index + length > this.capacity()) {
            throw new IndexOutOfBoundsException("Too many bytes to convert - Needs" + (index + length) + ", maximum is " + this.capacity());
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index must be >= 0");
        }
        if (length == 0) {
            return new ByteBuffer[0];
        }
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(this.components.length);
        int i = this.componentId(index);
        while (length > 0) {
            ChannelBuffer s = this.components[i];
            int adjustment = this.indices[i];
            int localLength = Math.min(length, s.capacity() - (index - adjustment));
            buffers.add(s.toByteBuffer(index - adjustment, localLength));
            index += localLength;
            length -= localLength;
            ++i;
        }
        return buffers.toArray(new ByteBuffer[buffers.size()]);
    }

    private int componentId(int index) {
        int lastComponentId = this.lastAccessedComponentId;
        if (index >= this.indices[lastComponentId]) {
            if (index < this.indices[lastComponentId + 1]) {
                return lastComponentId;
            }
            for (int i = lastComponentId + 1; i < this.components.length; ++i) {
                if (index >= this.indices[i + 1]) continue;
                this.lastAccessedComponentId = i;
                return i;
            }
        } else {
            for (int i = lastComponentId - 1; i >= 0; --i) {
                if (index < this.indices[i]) continue;
                this.lastAccessedComponentId = i;
                return i;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + index + ", maximum: " + this.indices.length);
    }

    @Override
    public void discardReadBytes() {
        int localReaderIndex = this.readerIndex();
        if (localReaderIndex == 0) {
            return;
        }
        int localWriterIndex = this.writerIndex();
        int bytesToMove = this.capacity() - localReaderIndex;
        List<ChannelBuffer> list = this.decompose(localReaderIndex, bytesToMove);
        if (list.isEmpty()) {
            list = new ArrayList<ChannelBuffer>(1);
        }
        ChannelBuffer padding = ChannelBuffers.buffer(this.order(), localReaderIndex);
        padding.writerIndex(localReaderIndex);
        list.add(padding);
        int localMarkedReaderIndex = localReaderIndex;
        try {
            this.resetReaderIndex();
            localMarkedReaderIndex = this.readerIndex();
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        int localMarkedWriterIndex = localWriterIndex;
        try {
            this.resetWriterIndex();
            localMarkedWriterIndex = this.writerIndex();
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        this.setComponents(list);
        localMarkedReaderIndex = Math.max(localMarkedReaderIndex - localReaderIndex, 0);
        localMarkedWriterIndex = Math.max(localMarkedWriterIndex - localReaderIndex, 0);
        this.setIndex(localMarkedReaderIndex, localMarkedWriterIndex);
        this.markReaderIndex();
        this.markWriterIndex();
        localWriterIndex = Math.max(localWriterIndex - localReaderIndex, 0);
        this.setIndex(0, localWriterIndex);
    }

    @Override
    public String toString() {
        String result = super.toString();
        result = result.substring(0, result.length() - 1);
        return result + ", components=" + this.components.length + ')';
    }
}

