/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.netty.channel.local;

import com.facebook.presto.jdbc.internal.netty.channel.AbstractServerChannel;
import com.facebook.presto.jdbc.internal.netty.channel.ChannelConfig;
import com.facebook.presto.jdbc.internal.netty.channel.ChannelFactory;
import com.facebook.presto.jdbc.internal.netty.channel.ChannelPipeline;
import com.facebook.presto.jdbc.internal.netty.channel.ChannelSink;
import com.facebook.presto.jdbc.internal.netty.channel.Channels;
import com.facebook.presto.jdbc.internal.netty.channel.DefaultServerChannelConfig;
import com.facebook.presto.jdbc.internal.netty.channel.local.LocalAddress;
import com.facebook.presto.jdbc.internal.netty.channel.local.LocalServerChannel;
import java.util.concurrent.atomic.AtomicBoolean;

final class DefaultLocalServerChannel
extends AbstractServerChannel
implements LocalServerChannel {
    final ChannelConfig channelConfig;
    final AtomicBoolean bound = new AtomicBoolean();
    volatile LocalAddress localAddress;

    DefaultLocalServerChannel(ChannelFactory factory, ChannelPipeline pipeline, ChannelSink sink) {
        super(factory, pipeline, sink);
        this.channelConfig = new DefaultServerChannelConfig();
        Channels.fireChannelOpen(this);
    }

    public ChannelConfig getConfig() {
        return this.channelConfig;
    }

    public boolean isBound() {
        return this.isOpen() && this.bound.get();
    }

    public LocalAddress getLocalAddress() {
        return this.isBound() ? this.localAddress : null;
    }

    public LocalAddress getRemoteAddress() {
        return null;
    }

    protected boolean setClosed() {
        return super.setClosed();
    }
}

