/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.netty.channel.socket.oio;

import com.facebook.presto.jdbc.internal.netty.channel.AbstractChannelSink;
import com.facebook.presto.jdbc.internal.netty.channel.Channel;
import com.facebook.presto.jdbc.internal.netty.channel.ChannelEvent;
import com.facebook.presto.jdbc.internal.netty.channel.ChannelFuture;
import com.facebook.presto.jdbc.internal.netty.channel.ChannelPipeline;
import com.facebook.presto.jdbc.internal.netty.channel.socket.ChannelRunnableWrapper;
import com.facebook.presto.jdbc.internal.netty.channel.socket.Worker;
import com.facebook.presto.jdbc.internal.netty.channel.socket.oio.AbstractOioChannel;
import com.facebook.presto.jdbc.internal.netty.channel.socket.oio.AbstractOioWorker;

public abstract class AbstractOioChannelSink
extends AbstractChannelSink {
    public ChannelFuture execute(ChannelPipeline pipeline, Runnable task) {
        Channel ch = pipeline.getChannel();
        if (ch instanceof AbstractOioChannel) {
            AbstractOioChannel channel = (AbstractOioChannel)ch;
            Worker worker = channel.worker;
            if (worker != null) {
                ChannelRunnableWrapper wrapper = new ChannelRunnableWrapper(pipeline.getChannel(), task);
                channel.worker.executeInIoThread(wrapper);
                return wrapper;
            }
        }
        return super.execute(pipeline, task);
    }

    protected boolean isFireExceptionCaughtLater(ChannelEvent event, Throwable actualCause) {
        Channel channel = event.getChannel();
        boolean fireLater = false;
        if (channel instanceof AbstractOioChannel) {
            fireLater = !AbstractOioWorker.isIoThread((AbstractOioChannel)channel);
        }
        return fireLater;
    }
}

