/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.netty.channel.socket.oio;

import com.facebook.presto.jdbc.internal.netty.channel.ChannelPipeline;
import com.facebook.presto.jdbc.internal.netty.channel.socket.ClientSocketChannelFactory;
import com.facebook.presto.jdbc.internal.netty.channel.socket.SocketChannel;
import com.facebook.presto.jdbc.internal.netty.channel.socket.oio.OioClientSocketChannel;
import com.facebook.presto.jdbc.internal.netty.channel.socket.oio.OioClientSocketPipelineSink;
import com.facebook.presto.jdbc.internal.netty.util.ThreadNameDeterminer;
import com.facebook.presto.jdbc.internal.netty.util.internal.ExecutorUtil;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class OioClientSocketChannelFactory
implements ClientSocketChannelFactory {
    private final Executor workerExecutor;
    final OioClientSocketPipelineSink sink;
    private boolean shutdownExecutor;

    public OioClientSocketChannelFactory() {
        this(Executors.newCachedThreadPool());
        this.shutdownExecutor = true;
    }

    public OioClientSocketChannelFactory(Executor workerExecutor) {
        this(workerExecutor, null);
    }

    public OioClientSocketChannelFactory(Executor workerExecutor, ThreadNameDeterminer determiner) {
        if (workerExecutor == null) {
            throw new NullPointerException("workerExecutor");
        }
        this.workerExecutor = workerExecutor;
        this.sink = new OioClientSocketPipelineSink(workerExecutor, determiner);
    }

    public SocketChannel newChannel(ChannelPipeline pipeline) {
        return new OioClientSocketChannel(this, pipeline, this.sink);
    }

    public void shutdown() {
        if (this.shutdownExecutor) {
            ExecutorUtil.shutdownNow(this.workerExecutor);
        }
    }

    public void releaseExternalResources() {
        this.shutdown();
        ExecutorUtil.shutdownNow(this.workerExecutor);
    }
}

