/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.netty.channel.socket.oio;

import com.facebook.presto.jdbc.internal.netty.channel.AbstractServerChannel;
import com.facebook.presto.jdbc.internal.netty.channel.ChannelException;
import com.facebook.presto.jdbc.internal.netty.channel.ChannelFactory;
import com.facebook.presto.jdbc.internal.netty.channel.ChannelPipeline;
import com.facebook.presto.jdbc.internal.netty.channel.ChannelSink;
import com.facebook.presto.jdbc.internal.netty.channel.Channels;
import com.facebook.presto.jdbc.internal.netty.channel.socket.DefaultServerSocketChannelConfig;
import com.facebook.presto.jdbc.internal.netty.channel.socket.ServerSocketChannel;
import com.facebook.presto.jdbc.internal.netty.channel.socket.ServerSocketChannelConfig;
import com.facebook.presto.jdbc.internal.netty.logging.InternalLogger;
import com.facebook.presto.jdbc.internal.netty.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

class OioServerSocketChannel
extends AbstractServerChannel
implements ServerSocketChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(OioServerSocketChannel.class);
    final ServerSocket socket;
    final Lock shutdownLock = new ReentrantLock();
    private final ServerSocketChannelConfig config;

    OioServerSocketChannel(ChannelFactory factory, ChannelPipeline pipeline, ChannelSink sink) {
        super(factory, pipeline, sink);
        try {
            this.socket = new ServerSocket();
        }
        catch (IOException e) {
            throw new ChannelException("Failed to open a server socket.", e);
        }
        try {
            this.socket.setSoTimeout(1000);
        }
        catch (IOException e) {
            block6: {
                try {
                    this.socket.close();
                }
                catch (IOException e2) {
                    if (!logger.isWarnEnabled()) break block6;
                    logger.warn("Failed to close a partially initialized socket.", e2);
                }
            }
            throw new ChannelException("Failed to set the server socket timeout.", e);
        }
        this.config = new DefaultServerSocketChannelConfig(this.socket);
        Channels.fireChannelOpen(this);
    }

    public ServerSocketChannelConfig getConfig() {
        return this.config;
    }

    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.socket.getLocalSocketAddress();
    }

    public InetSocketAddress getRemoteAddress() {
        return null;
    }

    public boolean isBound() {
        return this.isOpen() && this.socket.isBound();
    }

    protected boolean setClosed() {
        return super.setClosed();
    }
}

