/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.netty.channel.socket.oio;

import com.facebook.presto.jdbc.internal.netty.channel.Channel;
import com.facebook.presto.jdbc.internal.netty.channel.ChannelException;
import com.facebook.presto.jdbc.internal.netty.channel.ChannelFactory;
import com.facebook.presto.jdbc.internal.netty.channel.ChannelPipeline;
import com.facebook.presto.jdbc.internal.netty.channel.ChannelSink;
import com.facebook.presto.jdbc.internal.netty.channel.socket.DefaultSocketChannelConfig;
import com.facebook.presto.jdbc.internal.netty.channel.socket.SocketChannel;
import com.facebook.presto.jdbc.internal.netty.channel.socket.SocketChannelConfig;
import com.facebook.presto.jdbc.internal.netty.channel.socket.oio.AbstractOioChannel;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;

abstract class OioSocketChannel
extends AbstractOioChannel
implements SocketChannel {
    final Socket socket;
    private final SocketChannelConfig config;

    OioSocketChannel(Channel parent, ChannelFactory factory, ChannelPipeline pipeline, ChannelSink sink, Socket socket) {
        super(parent, factory, pipeline, sink);
        this.socket = socket;
        try {
            socket.setSoTimeout(1000);
        }
        catch (SocketException e) {
            throw new ChannelException("Failed to configure the OioSocketChannel socket timeout.", e);
        }
        this.config = new DefaultSocketChannelConfig(socket);
    }

    public SocketChannelConfig getConfig() {
        return this.config;
    }

    abstract PushbackInputStream getInputStream();

    abstract OutputStream getOutputStream();

    boolean isSocketBound() {
        return this.socket.isBound();
    }

    boolean isSocketConnected() {
        return this.socket.isConnected();
    }

    InetSocketAddress getLocalSocketAddress() throws Exception {
        return (InetSocketAddress)this.socket.getLocalSocketAddress();
    }

    InetSocketAddress getRemoteSocketAddress() throws Exception {
        return (InetSocketAddress)this.socket.getRemoteSocketAddress();
    }

    void closeSocket() throws IOException {
        this.socket.close();
    }

    boolean isSocketClosed() {
        return this.socket.isClosed();
    }
}

