/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.netty.handler.codec.embedder;

import com.facebook.presto.jdbc.internal.netty.buffer.ChannelBufferFactory;
import com.facebook.presto.jdbc.internal.netty.channel.Channel;
import com.facebook.presto.jdbc.internal.netty.channel.ChannelEvent;
import com.facebook.presto.jdbc.internal.netty.channel.ChannelFuture;
import com.facebook.presto.jdbc.internal.netty.channel.ChannelHandler;
import com.facebook.presto.jdbc.internal.netty.channel.ChannelHandlerContext;
import com.facebook.presto.jdbc.internal.netty.channel.ChannelPipeline;
import com.facebook.presto.jdbc.internal.netty.channel.ChannelPipelineException;
import com.facebook.presto.jdbc.internal.netty.channel.ChannelSink;
import com.facebook.presto.jdbc.internal.netty.channel.ChannelUpstreamHandler;
import com.facebook.presto.jdbc.internal.netty.channel.Channels;
import com.facebook.presto.jdbc.internal.netty.channel.DefaultChannelPipeline;
import com.facebook.presto.jdbc.internal.netty.channel.ExceptionEvent;
import com.facebook.presto.jdbc.internal.netty.channel.MessageEvent;
import com.facebook.presto.jdbc.internal.netty.handler.codec.embedder.CodecEmbedder;
import com.facebook.presto.jdbc.internal.netty.handler.codec.embedder.CodecEmbedderException;
import com.facebook.presto.jdbc.internal.netty.handler.codec.embedder.EmbeddedChannel;
import java.lang.reflect.Array;
import java.util.ConcurrentModificationException;
import java.util.LinkedList;
import java.util.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractCodecEmbedder<E>
implements CodecEmbedder<E> {
    private final Channel channel;
    private final ChannelPipeline pipeline;
    private final EmbeddedChannelSink sink = new EmbeddedChannelSink();
    final Queue<Object> productQueue = new LinkedList<Object>();

    protected AbstractCodecEmbedder(ChannelHandler ... handlers) {
        this.pipeline = new EmbeddedChannelPipeline();
        this.configurePipeline(handlers);
        this.channel = new EmbeddedChannel(this.pipeline, this.sink);
        this.fireInitialEvents();
    }

    protected AbstractCodecEmbedder(ChannelBufferFactory bufferFactory, ChannelHandler ... handlers) {
        this(handlers);
        this.getChannel().getConfig().setBufferFactory(bufferFactory);
    }

    private void fireInitialEvents() {
        Channels.fireChannelOpen(this.channel);
        Channels.fireChannelBound(this.channel, this.channel.getLocalAddress());
        Channels.fireChannelConnected(this.channel, this.channel.getRemoteAddress());
    }

    private void configurePipeline(ChannelHandler ... handlers) {
        if (handlers == null) {
            throw new NullPointerException("handlers");
        }
        if (handlers.length == 0) {
            throw new IllegalArgumentException("handlers should contain at least one " + ChannelHandler.class.getSimpleName() + '.');
        }
        for (int i = 0; i < handlers.length; ++i) {
            ChannelHandler h = handlers[i];
            if (h == null) {
                throw new NullPointerException("handlers[" + i + ']');
            }
            this.pipeline.addLast(String.valueOf(i), handlers[i]);
        }
        this.pipeline.addLast("SINK", this.sink);
    }

    @Override
    public boolean finish() {
        Channels.close(this.channel);
        Channels.fireChannelDisconnected(this.channel);
        Channels.fireChannelUnbound(this.channel);
        Channels.fireChannelClosed(this.channel);
        return !this.productQueue.isEmpty();
    }

    protected final Channel getChannel() {
        return this.channel;
    }

    protected final boolean isEmpty() {
        return this.productQueue.isEmpty();
    }

    @Override
    public final E poll() {
        return (E)this.productQueue.poll();
    }

    @Override
    public final E peek() {
        return (E)this.productQueue.peek();
    }

    @Override
    public final Object[] pollAll() {
        int size = this.size();
        Object[] a = new Object[size];
        for (int i = 0; i < size; ++i) {
            E product = this.poll();
            if (product == null) {
                throw new ConcurrentModificationException();
            }
            a[i] = product;
        }
        return a;
    }

    @Override
    public final <T> T[] pollAll(T[] a) {
        E product;
        if (a == null) {
            throw new NullPointerException("a");
        }
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        int i = 0;
        while ((product = this.poll()) != null) {
            a[i] = product;
            ++i;
        }
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    @Override
    public final int size() {
        return this.productQueue.size();
    }

    @Override
    public ChannelPipeline getPipeline() {
        return this.pipeline;
    }

    private static final class EmbeddedChannelPipeline
    extends DefaultChannelPipeline {
        EmbeddedChannelPipeline() {
        }

        protected void notifyHandlerException(ChannelEvent e, Throwable t) {
            while (t instanceof ChannelPipelineException && t.getCause() != null) {
                t = t.getCause();
            }
            if (t instanceof CodecEmbedderException) {
                throw (CodecEmbedderException)t;
            }
            throw new CodecEmbedderException(t);
        }
    }

    private final class EmbeddedChannelSink
    implements ChannelSink,
    ChannelUpstreamHandler {
        EmbeddedChannelSink() {
        }

        public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) {
            this.handleEvent(e);
        }

        public void eventSunk(ChannelPipeline pipeline, ChannelEvent e) {
            this.handleEvent(e);
        }

        private void handleEvent(ChannelEvent e) {
            if (e instanceof MessageEvent) {
                boolean offered = AbstractCodecEmbedder.this.productQueue.offer(((MessageEvent)e).getMessage());
                assert (offered);
            } else if (e instanceof ExceptionEvent) {
                throw new CodecEmbedderException(((ExceptionEvent)e).getCause());
            }
        }

        public void exceptionCaught(ChannelPipeline pipeline, ChannelEvent e, ChannelPipelineException cause) throws Exception {
            Throwable actualCause = cause.getCause();
            if (actualCause == null) {
                actualCause = cause;
            }
            throw new CodecEmbedderException(actualCause);
        }

        public ChannelFuture execute(ChannelPipeline pipeline, Runnable task) {
            try {
                task.run();
                return Channels.succeededFuture(pipeline.getChannel());
            }
            catch (Throwable t) {
                return Channels.failedFuture(pipeline.getChannel(), t);
            }
        }
    }
}

