/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.netty.handler.codec.frame;

import com.facebook.presto.jdbc.internal.netty.buffer.ChannelBuffer;
import com.facebook.presto.jdbc.internal.netty.buffer.ChannelBufferFactory;
import com.facebook.presto.jdbc.internal.netty.buffer.ChannelBuffers;
import com.facebook.presto.jdbc.internal.netty.buffer.CompositeChannelBuffer;
import com.facebook.presto.jdbc.internal.netty.channel.Channel;
import com.facebook.presto.jdbc.internal.netty.channel.ChannelHandler;
import com.facebook.presto.jdbc.internal.netty.channel.ChannelHandlerContext;
import com.facebook.presto.jdbc.internal.netty.channel.ChannelPipeline;
import com.facebook.presto.jdbc.internal.netty.channel.ChannelStateEvent;
import com.facebook.presto.jdbc.internal.netty.channel.Channels;
import com.facebook.presto.jdbc.internal.netty.channel.ExceptionEvent;
import com.facebook.presto.jdbc.internal.netty.channel.LifeCycleAwareChannelHandler;
import com.facebook.presto.jdbc.internal.netty.channel.MessageEvent;
import com.facebook.presto.jdbc.internal.netty.channel.SimpleChannelUpstreamHandler;
import java.net.SocketAddress;

public abstract class FrameDecoder
extends SimpleChannelUpstreamHandler
implements LifeCycleAwareChannelHandler {
    public static final int DEFAULT_MAX_COMPOSITEBUFFER_COMPONENTS = 1024;
    private boolean unfold;
    protected ChannelBuffer cumulation;
    private volatile ChannelHandlerContext ctx;
    private int copyThreshold;
    private int maxCumulationBufferComponents = 1024;

    protected FrameDecoder() {
        this(false);
    }

    protected FrameDecoder(boolean unfold) {
        this.unfold = unfold;
    }

    public final boolean isUnfold() {
        return this.unfold;
    }

    public final void setUnfold(boolean unfold) {
        if (this.ctx != null) {
            throw new IllegalStateException("decoder properties cannot be changed once the decoder is added to a pipeline.");
        }
        this.unfold = unfold;
    }

    public final int getMaxCumulationBufferCapacity() {
        return this.copyThreshold;
    }

    public final void setMaxCumulationBufferCapacity(int copyThreshold) {
        if (copyThreshold < 0) {
            throw new IllegalArgumentException("maxCumulationBufferCapacity must be >= 0");
        }
        if (this.ctx != null) {
            throw new IllegalStateException("decoder properties cannot be changed once the decoder is added to a pipeline.");
        }
        this.copyThreshold = copyThreshold;
    }

    public final int getMaxCumulationBufferComponents() {
        return this.maxCumulationBufferComponents;
    }

    public final void setMaxCumulationBufferComponents(int maxCumulationBufferComponents) {
        if (maxCumulationBufferComponents < 2) {
            throw new IllegalArgumentException("maxCumulationBufferComponents: " + maxCumulationBufferComponents + " (expected: >= 2)");
        }
        if (this.ctx != null) {
            throw new IllegalStateException("decoder properties cannot be changed once the decoder is added to a pipeline.");
        }
        this.maxCumulationBufferComponents = maxCumulationBufferComponents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        Object m = e.getMessage();
        if (!(m instanceof ChannelBuffer)) {
            ctx.sendUpstream(e);
            return;
        }
        ChannelBuffer input = (ChannelBuffer)m;
        if (!input.readable()) {
            return;
        }
        if (this.cumulation == null) {
            try {
                this.callDecode(ctx, e.getChannel(), input, e.getRemoteAddress());
            }
            finally {
                this.updateCumulation(ctx, input);
            }
        }
        input = this.appendToCumulation(input);
        try {
            this.callDecode(ctx, e.getChannel(), input, e.getRemoteAddress());
        }
        finally {
            this.updateCumulation(ctx, input);
        }
    }

    protected ChannelBuffer appendToCumulation(ChannelBuffer input) {
        CompositeChannelBuffer composite;
        ChannelBuffer cumulation = this.cumulation;
        assert (cumulation.readable());
        if (cumulation instanceof CompositeChannelBuffer && (composite = (CompositeChannelBuffer)cumulation).numComponents() >= this.maxCumulationBufferComponents) {
            cumulation = composite.copy();
        }
        this.cumulation = input = ChannelBuffers.wrappedBuffer(cumulation, input);
        return input;
    }

    protected ChannelBuffer updateCumulation(ChannelHandlerContext ctx, ChannelBuffer input) {
        ChannelBuffer newCumulation;
        int readableBytes = input.readableBytes();
        if (readableBytes > 0) {
            int inputCapacity = input.capacity();
            if (readableBytes < inputCapacity && inputCapacity > this.copyThreshold) {
                this.cumulation = newCumulation = this.newCumulationBuffer(ctx, input.readableBytes());
                this.cumulation.writeBytes(input);
            } else {
                this.cumulation = input.readerIndex() != 0 ? (newCumulation = input.slice()) : (newCumulation = input);
            }
        } else {
            newCumulation = null;
            this.cumulation = null;
        }
        return newCumulation;
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.cleanup(ctx, e);
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.cleanup(ctx, e);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        ctx.sendUpstream(e);
    }

    protected abstract Object decode(ChannelHandlerContext var1, Channel var2, ChannelBuffer var3) throws Exception;

    protected Object decodeLast(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        return this.decode(ctx, channel, buffer);
    }

    private void callDecode(ChannelHandlerContext context, Channel channel, ChannelBuffer cumulation, SocketAddress remoteAddress) throws Exception {
        while (cumulation.readable()) {
            int oldReaderIndex = cumulation.readerIndex();
            Object frame = this.decode(context, channel, cumulation);
            if (frame == null) {
                if (oldReaderIndex != cumulation.readerIndex()) continue;
                break;
            }
            if (oldReaderIndex == cumulation.readerIndex()) {
                throw new IllegalStateException("decode() method must read at least one byte if it returned a frame (caused by: " + this.getClass() + ')');
            }
            this.unfoldAndFireMessageReceived(context, remoteAddress, frame);
        }
    }

    protected final void unfoldAndFireMessageReceived(ChannelHandlerContext context, SocketAddress remoteAddress, Object result) {
        if (this.unfold) {
            if (result instanceof Object[]) {
                for (Object r : (Object[])result) {
                    Channels.fireMessageReceived(context, r, remoteAddress);
                }
            } else if (result instanceof Iterable) {
                for (Object r : (Iterable)result) {
                    Channels.fireMessageReceived(context, r, remoteAddress);
                }
            } else {
                Channels.fireMessageReceived(context, result, remoteAddress);
            }
        } else {
            Channels.fireMessageReceived(context, result, remoteAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanup(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        try {
            Object partialFrame;
            ChannelBuffer cumulation = this.cumulation;
            if (cumulation == null) {
                return;
            }
            this.cumulation = null;
            if (cumulation.readable()) {
                this.callDecode(ctx, ctx.getChannel(), cumulation, null);
            }
            if ((partialFrame = this.decodeLast(ctx, ctx.getChannel(), cumulation)) != null) {
                this.unfoldAndFireMessageReceived(ctx, null, partialFrame);
            }
        }
        finally {
            ctx.sendUpstream(e);
        }
    }

    protected ChannelBuffer newCumulationBuffer(ChannelHandlerContext ctx, int minimumCapacity) {
        ChannelBufferFactory factory = ctx.getChannel().getConfig().getBufferFactory();
        return factory.getBuffer(Math.max(minimumCapacity, 256));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(String handlerName, ChannelHandler handler) {
        if (this.ctx == null) {
            throw new IllegalStateException("Replace cann only be called once the FrameDecoder is added to the ChannelPipeline");
        }
        ChannelPipeline pipeline = this.ctx.getPipeline();
        pipeline.addAfter(this.ctx.getName(), handlerName, handler);
        try {
            if (this.cumulation != null) {
                Channels.fireMessageReceived(this.ctx, (Object)this.cumulation.readBytes(this.actualReadableBytes()));
            }
        }
        finally {
            pipeline.remove(this);
        }
    }

    protected int actualReadableBytes() {
        return this.internalBuffer().readableBytes();
    }

    protected ChannelBuffer internalBuffer() {
        ChannelBuffer buf = this.cumulation;
        if (buf == null) {
            return ChannelBuffers.EMPTY_BUFFER;
        }
        return buf;
    }

    protected ChannelBuffer extractFrame(ChannelBuffer buffer, int index, int length) {
        ChannelBuffer frame = buffer.factory().getBuffer(length);
        frame.writeBytes(buffer, index, length);
        return frame;
    }

    public void beforeAdd(ChannelHandlerContext ctx) throws Exception {
        this.ctx = ctx;
    }

    public void afterAdd(ChannelHandlerContext ctx) throws Exception {
    }

    public void beforeRemove(ChannelHandlerContext ctx) throws Exception {
    }

    public void afterRemove(ChannelHandlerContext ctx) throws Exception {
    }
}

