/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.netty.handler.codec.http.websocketx;

import com.facebook.presto.jdbc.internal.netty.channel.Channel;
import com.facebook.presto.jdbc.internal.netty.channel.ChannelFuture;
import com.facebook.presto.jdbc.internal.netty.channel.ChannelFutureListener;
import com.facebook.presto.jdbc.internal.netty.channel.Channels;
import com.facebook.presto.jdbc.internal.netty.handler.codec.http.HttpRequest;
import com.facebook.presto.jdbc.internal.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import com.facebook.presto.jdbc.internal.netty.handler.codec.http.websocketx.WebSocketVersion;
import com.facebook.presto.jdbc.internal.netty.util.internal.StringUtil;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WebSocketServerHandshaker {
    public static final String SUB_PROTOCOL_WILDCARD = "*";
    private final String webSocketUrl;
    private final String[] subprotocols;
    private final WebSocketVersion version;
    private final long maxFramePayloadLength;
    private String selectedSubprotocol;
    public static final ChannelFutureListener HANDSHAKE_LISTENER = new ChannelFutureListener(){

        public void operationComplete(ChannelFuture future) throws Exception {
            if (!future.isSuccess()) {
                Channels.fireExceptionCaught(future.getChannel(), future.getCause());
            }
        }
    };

    protected WebSocketServerHandshaker(WebSocketVersion version, String webSocketUrl, String subprotocols) {
        this(version, webSocketUrl, subprotocols, Long.MAX_VALUE);
    }

    protected WebSocketServerHandshaker(WebSocketVersion version, String webSocketUrl, String subprotocols, long maxFramePayloadLength) {
        this.version = version;
        this.webSocketUrl = webSocketUrl;
        if (subprotocols != null) {
            String[] subprotocolArray = StringUtil.split(subprotocols, ',');
            for (int i = 0; i < subprotocolArray.length; ++i) {
                subprotocolArray[i] = subprotocolArray[i].trim();
            }
            this.subprotocols = subprotocolArray;
        } else {
            this.subprotocols = new String[0];
        }
        this.maxFramePayloadLength = maxFramePayloadLength;
    }

    public String getWebSocketUrl() {
        return this.webSocketUrl;
    }

    public Set<String> getSubprotocols() {
        LinkedHashSet<String> ret = new LinkedHashSet<String>();
        Collections.addAll(ret, this.subprotocols);
        return ret;
    }

    public WebSocketVersion getVersion() {
        return this.version;
    }

    public long getMaxFramePayloadLength() {
        return this.maxFramePayloadLength;
    }

    public abstract ChannelFuture handshake(Channel var1, HttpRequest var2);

    public abstract ChannelFuture close(Channel var1, CloseWebSocketFrame var2);

    protected String selectSubprotocol(String requestedSubprotocols) {
        String[] requestedSubprotocolArray;
        if (requestedSubprotocols == null || this.subprotocols.length == 0) {
            return null;
        }
        for (String p : requestedSubprotocolArray = StringUtil.split(requestedSubprotocols, ',')) {
            String requestedSubprotocol = p.trim();
            for (String supportedSubprotocol : this.subprotocols) {
                if (!SUB_PROTOCOL_WILDCARD.equals(supportedSubprotocol) && !requestedSubprotocol.equals(supportedSubprotocol)) continue;
                return requestedSubprotocol;
            }
        }
        return null;
    }

    public String getSelectedSubprotocol() {
        return this.selectedSubprotocol;
    }

    protected void setSelectedSubprotocol(String value) {
        this.selectedSubprotocol = value;
    }
}

