/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.netty.handler.codec.http.websocketx;

import com.facebook.presto.jdbc.internal.netty.buffer.ChannelBuffer;
import com.facebook.presto.jdbc.internal.netty.buffer.ChannelBuffers;
import com.facebook.presto.jdbc.internal.netty.channel.Channel;
import com.facebook.presto.jdbc.internal.netty.channel.ChannelFuture;
import com.facebook.presto.jdbc.internal.netty.channel.ChannelFutureListener;
import com.facebook.presto.jdbc.internal.netty.channel.ChannelHandler;
import com.facebook.presto.jdbc.internal.netty.channel.ChannelPipeline;
import com.facebook.presto.jdbc.internal.netty.handler.codec.http.DefaultHttpResponse;
import com.facebook.presto.jdbc.internal.netty.handler.codec.http.HttpChunkAggregator;
import com.facebook.presto.jdbc.internal.netty.handler.codec.http.HttpRequest;
import com.facebook.presto.jdbc.internal.netty.handler.codec.http.HttpRequestDecoder;
import com.facebook.presto.jdbc.internal.netty.handler.codec.http.HttpResponseEncoder;
import com.facebook.presto.jdbc.internal.netty.handler.codec.http.HttpResponseStatus;
import com.facebook.presto.jdbc.internal.netty.handler.codec.http.HttpVersion;
import com.facebook.presto.jdbc.internal.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import com.facebook.presto.jdbc.internal.netty.handler.codec.http.websocketx.WebSocket07FrameDecoder;
import com.facebook.presto.jdbc.internal.netty.handler.codec.http.websocketx.WebSocket07FrameEncoder;
import com.facebook.presto.jdbc.internal.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import com.facebook.presto.jdbc.internal.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import com.facebook.presto.jdbc.internal.netty.handler.codec.http.websocketx.WebSocketUtil;
import com.facebook.presto.jdbc.internal.netty.handler.codec.http.websocketx.WebSocketVersion;
import com.facebook.presto.jdbc.internal.netty.logging.InternalLogger;
import com.facebook.presto.jdbc.internal.netty.logging.InternalLoggerFactory;
import com.facebook.presto.jdbc.internal.netty.util.CharsetUtil;

public class WebSocketServerHandshaker07
extends WebSocketServerHandshaker {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(WebSocketServerHandshaker07.class);
    public static final String WEBSOCKET_07_ACCEPT_GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private final boolean allowExtensions;

    public WebSocketServerHandshaker07(String webSocketURL, String subprotocols, boolean allowExtensions, long maxFramePayloadLength) {
        super(WebSocketVersion.V07, webSocketURL, subprotocols, maxFramePayloadLength);
        this.allowExtensions = allowExtensions;
    }

    public ChannelFuture handshake(Channel channel, HttpRequest req) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Channel %s WS Version 7 server handshake", channel.getId()));
        }
        DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.SWITCHING_PROTOCOLS);
        String key = req.getHeader("Sec-WebSocket-Key");
        if (key == null) {
            throw new WebSocketHandshakeException("not a WebSocket request: missing key");
        }
        String acceptSeed = key + WEBSOCKET_07_ACCEPT_GUID;
        ChannelBuffer sha1 = WebSocketUtil.sha1(ChannelBuffers.copiedBuffer((CharSequence)acceptSeed, CharsetUtil.US_ASCII));
        String accept = WebSocketUtil.base64(sha1);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("WS Version 7 Server Handshake key: %s. Response: %s.", key, accept));
        }
        res.setStatus(HttpResponseStatus.SWITCHING_PROTOCOLS);
        res.addHeader("Upgrade", "WebSocket".toLowerCase());
        res.addHeader("Connection", "Upgrade");
        res.addHeader("Sec-WebSocket-Accept", accept);
        String subprotocols = req.getHeader("Sec-WebSocket-Protocol");
        if (subprotocols != null) {
            String selectedSubprotocol = this.selectSubprotocol(subprotocols);
            if (selectedSubprotocol == null) {
                throw new WebSocketHandshakeException("Requested subprotocol(s) not supported: " + subprotocols);
            }
            res.addHeader("Sec-WebSocket-Protocol", selectedSubprotocol);
            this.setSelectedSubprotocol(selectedSubprotocol);
        }
        ChannelFuture future = channel.write(res);
        future.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) {
                ChannelPipeline p = future.getChannel().getPipeline();
                if (p.get(HttpChunkAggregator.class) != null) {
                    p.remove(HttpChunkAggregator.class);
                }
                p.get(HttpRequestDecoder.class).replace("wsdecoder", new WebSocket07FrameDecoder(true, WebSocketServerHandshaker07.this.allowExtensions, WebSocketServerHandshaker07.this.getMaxFramePayloadLength()));
                p.replace(HttpResponseEncoder.class, "wsencoder", (ChannelHandler)new WebSocket07FrameEncoder(false));
            }
        });
        return future;
    }

    public ChannelFuture close(Channel channel, CloseWebSocketFrame frame) {
        ChannelFuture future = channel.write(frame);
        future.addListener(ChannelFutureListener.CLOSE);
        return future;
    }
}

