/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.netty.handler.codec.http.websocketx;

import com.facebook.presto.jdbc.internal.netty.buffer.ChannelBuffers;
import com.facebook.presto.jdbc.internal.netty.channel.ChannelFutureListener;
import com.facebook.presto.jdbc.internal.netty.channel.ChannelHandler;
import com.facebook.presto.jdbc.internal.netty.channel.ChannelHandlerContext;
import com.facebook.presto.jdbc.internal.netty.channel.ChannelPipeline;
import com.facebook.presto.jdbc.internal.netty.channel.ExceptionEvent;
import com.facebook.presto.jdbc.internal.netty.channel.LifeCycleAwareChannelHandler;
import com.facebook.presto.jdbc.internal.netty.channel.MessageEvent;
import com.facebook.presto.jdbc.internal.netty.channel.SimpleChannelHandler;
import com.facebook.presto.jdbc.internal.netty.channel.SimpleChannelUpstreamHandler;
import com.facebook.presto.jdbc.internal.netty.handler.codec.http.DefaultHttpResponse;
import com.facebook.presto.jdbc.internal.netty.handler.codec.http.HttpResponseStatus;
import com.facebook.presto.jdbc.internal.netty.handler.codec.http.HttpVersion;
import com.facebook.presto.jdbc.internal.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import com.facebook.presto.jdbc.internal.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import com.facebook.presto.jdbc.internal.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import com.facebook.presto.jdbc.internal.netty.handler.codec.http.websocketx.WebSocketFrame;
import com.facebook.presto.jdbc.internal.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import com.facebook.presto.jdbc.internal.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import com.facebook.presto.jdbc.internal.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandshakeHandler;

public class WebSocketServerProtocolHandler
extends SimpleChannelUpstreamHandler
implements LifeCycleAwareChannelHandler {
    private final String websocketPath;
    private final String subprotocols;
    private final boolean allowExtensions;

    public WebSocketServerProtocolHandler(String websocketPath) {
        this(websocketPath, null, false);
    }

    public WebSocketServerProtocolHandler(String websocketPath, String subprotocols) {
        this(websocketPath, subprotocols, false);
    }

    public WebSocketServerProtocolHandler(String websocketPath, String subprotocols, boolean allowExtensions) {
        this.websocketPath = websocketPath;
        this.subprotocols = subprotocols;
        this.allowExtensions = allowExtensions;
    }

    public void afterAdd(ChannelHandlerContext ctx) throws Exception {
        ChannelPipeline cp = ctx.getPipeline();
        if (cp.get(WebSocketServerProtocolHandshakeHandler.class) == null) {
            ctx.getPipeline().addBefore(ctx.getName(), WebSocketServerProtocolHandshakeHandler.class.getName(), new WebSocketServerProtocolHandshakeHandler(this.websocketPath, this.subprotocols, this.allowExtensions));
        }
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        if (e.getMessage() instanceof WebSocketFrame) {
            WebSocketFrame frame = (WebSocketFrame)e.getMessage();
            if (frame instanceof CloseWebSocketFrame) {
                WebSocketServerHandshaker handshaker = WebSocketServerProtocolHandler.getHandshaker(ctx);
                handshaker.close(ctx.getChannel(), (CloseWebSocketFrame)frame);
                return;
            }
            if (frame instanceof PingWebSocketFrame) {
                ctx.getChannel().write(new PongWebSocketFrame(frame.getBinaryData()));
                return;
            }
        }
        ctx.sendUpstream(e);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        if (e.getCause() instanceof WebSocketHandshakeException) {
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST);
            response.setContent(ChannelBuffers.wrappedBuffer(e.getCause().getMessage().getBytes()));
            ctx.getChannel().write(response).addListener(ChannelFutureListener.CLOSE);
        } else {
            ctx.getChannel().close();
        }
    }

    static WebSocketServerHandshaker getHandshaker(ChannelHandlerContext ctx) {
        return (WebSocketServerHandshaker)ctx.getAttachment();
    }

    static void setHandshaker(ChannelHandlerContext ctx, WebSocketServerHandshaker handshaker) {
        ctx.setAttachment(handshaker);
    }

    static ChannelHandler forbiddenHttpRequestResponder() {
        return new SimpleChannelHandler(){

            public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
                if (!(e.getMessage() instanceof WebSocketFrame)) {
                    DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN);
                    ctx.getChannel().write(response);
                } else {
                    ctx.sendUpstream(e);
                }
            }
        };
    }

    public void beforeAdd(ChannelHandlerContext ctx) throws Exception {
    }

    public void beforeRemove(ChannelHandlerContext ctx) throws Exception {
    }

    public void afterRemove(ChannelHandlerContext ctx) throws Exception {
    }
}

