/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.netty.handler.codec.socks;

import com.facebook.presto.jdbc.internal.netty.buffer.ChannelBuffer;
import com.facebook.presto.jdbc.internal.netty.channel.Channel;
import com.facebook.presto.jdbc.internal.netty.channel.ChannelHandlerContext;
import com.facebook.presto.jdbc.internal.netty.handler.codec.replay.ReplayingDecoder;
import com.facebook.presto.jdbc.internal.netty.handler.codec.socks.SocksCmdResponse;
import com.facebook.presto.jdbc.internal.netty.handler.codec.socks.SocksCommonUtils;
import com.facebook.presto.jdbc.internal.netty.handler.codec.socks.SocksMessage;
import com.facebook.presto.jdbc.internal.netty.handler.codec.socks.SocksResponse;
import com.facebook.presto.jdbc.internal.netty.util.CharsetUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocksCmdResponseDecoder
extends ReplayingDecoder<State> {
    private static final String name = "SOCKS_CMD_RESPONSE_DECODER";
    private SocksMessage.ProtocolVersion version;
    private int fieldLength;
    private SocksMessage.CmdStatus cmdStatus;
    private SocksMessage.AddressType addressType;
    private byte reserved;
    private String host;
    private int port;
    private SocksResponse msg = SocksCommonUtils.UNKNOWN_SOCKS_RESPONSE;

    public static String getName() {
        return name;
    }

    public SocksCmdResponseDecoder() {
        super(State.CHECK_PROTOCOL_VERSION);
    }

    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer, State state) throws Exception {
        block0 : switch (state) {
            case CHECK_PROTOCOL_VERSION: {
                this.version = SocksMessage.ProtocolVersion.fromByte(buffer.readByte());
                if (this.version != SocksMessage.ProtocolVersion.SOCKS5) break;
                this.checkpoint(State.READ_CMD_HEADER);
            }
            case READ_CMD_HEADER: {
                this.cmdStatus = SocksMessage.CmdStatus.fromByte(buffer.readByte());
                this.reserved = buffer.readByte();
                this.addressType = SocksMessage.AddressType.fromByte(buffer.readByte());
                this.checkpoint(State.READ_CMD_ADDRESS);
            }
            case READ_CMD_ADDRESS: {
                switch (this.addressType) {
                    case IPv4: {
                        this.host = SocksCommonUtils.intToIp(buffer.readInt());
                        this.port = buffer.readUnsignedShort();
                        this.msg = new SocksCmdResponse(this.cmdStatus, this.addressType);
                        break block0;
                    }
                    case DOMAIN: {
                        this.fieldLength = buffer.readByte();
                        this.host = buffer.readBytes(this.fieldLength).toString(CharsetUtil.US_ASCII);
                        this.port = buffer.readUnsignedShort();
                        this.msg = new SocksCmdResponse(this.cmdStatus, this.addressType);
                        break block0;
                    }
                    case IPv6: {
                        this.host = SocksCommonUtils.ipv6toStr(buffer.readBytes(16).array());
                        this.port = buffer.readUnsignedShort();
                        this.msg = new SocksCmdResponse(this.cmdStatus, this.addressType);
                        break block0;
                    }
                }
            }
        }
        ctx.getPipeline().remove(this);
        return this.msg;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        CHECK_PROTOCOL_VERSION,
        READ_CMD_HEADER,
        READ_CMD_ADDRESS;

    }
}

