/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.netty.handler.codec.spdy;

import com.facebook.presto.jdbc.internal.netty.buffer.ChannelBuffer;
import com.facebook.presto.jdbc.internal.netty.buffer.ChannelBuffers;
import com.facebook.presto.jdbc.internal.netty.handler.codec.spdy.DefaultSpdyStreamFrame;
import com.facebook.presto.jdbc.internal.netty.handler.codec.spdy.SpdyDataFrame;
import com.facebook.presto.jdbc.internal.netty.util.internal.StringUtil;

public class DefaultSpdyDataFrame
extends DefaultSpdyStreamFrame
implements SpdyDataFrame {
    private ChannelBuffer data = ChannelBuffers.EMPTY_BUFFER;

    public DefaultSpdyDataFrame(int streamId) {
        super(streamId);
    }

    public ChannelBuffer getData() {
        return this.data;
    }

    public void setData(ChannelBuffer data) {
        if (data == null) {
            data = ChannelBuffers.EMPTY_BUFFER;
        }
        if (data.readableBytes() > 0xFFFFFF) {
            throw new IllegalArgumentException("data payload cannot exceed 16777215 bytes");
        }
        this.data = data;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName());
        buf.append("(last: ");
        buf.append(this.isLast());
        buf.append(')');
        buf.append(StringUtil.NEWLINE);
        buf.append("--> Stream-ID = ");
        buf.append(this.getStreamId());
        buf.append(StringUtil.NEWLINE);
        buf.append("--> Size = ");
        buf.append(this.getData().readableBytes());
        return buf.toString();
    }
}

