/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.netty.handler.codec.spdy;

import com.facebook.presto.jdbc.internal.netty.handler.codec.spdy.DefaultSpdyStreamFrame;
import com.facebook.presto.jdbc.internal.netty.handler.codec.spdy.SpdyHeaders;
import com.facebook.presto.jdbc.internal.netty.handler.codec.spdy.SpdyHeadersFrame;
import com.facebook.presto.jdbc.internal.netty.util.internal.StringUtil;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSpdyHeadersFrame
extends DefaultSpdyStreamFrame
implements SpdyHeadersFrame {
    private boolean invalid;
    private boolean truncated;
    private final SpdyHeaders headers = new SpdyHeaders();

    public DefaultSpdyHeadersFrame(int streamId) {
        super(streamId);
    }

    @Override
    public boolean isInvalid() {
        return this.invalid;
    }

    @Override
    public void setInvalid() {
        this.invalid = true;
    }

    @Override
    public boolean isTruncated() {
        return this.truncated;
    }

    @Override
    public void setTruncated() {
        this.truncated = true;
    }

    @Override
    public void addHeader(String name, Object value) {
        this.headers.addHeader(name, value);
    }

    @Override
    public void setHeader(String name, Object value) {
        this.headers.setHeader(name, value);
    }

    @Override
    public void setHeader(String name, Iterable<?> values) {
        this.headers.setHeader(name, values);
    }

    @Override
    public void removeHeader(String name) {
        this.headers.removeHeader(name);
    }

    @Override
    public void clearHeaders() {
        this.headers.clearHeaders();
    }

    @Override
    public String getHeader(String name) {
        return this.headers.getHeader(name);
    }

    @Override
    public List<String> getHeaders(String name) {
        return this.headers.getHeaders(name);
    }

    @Override
    public List<Map.Entry<String, String>> getHeaders() {
        return this.headers.getHeaders();
    }

    @Override
    public boolean containsHeader(String name) {
        return this.headers.containsHeader(name);
    }

    @Override
    public Set<String> getHeaderNames() {
        return this.headers.getHeaderNames();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName());
        buf.append("(last: ");
        buf.append(this.isLast());
        buf.append(')');
        buf.append(StringUtil.NEWLINE);
        buf.append("--> Stream-ID = ");
        buf.append(this.getStreamId());
        buf.append(StringUtil.NEWLINE);
        buf.append("--> Headers:");
        buf.append(StringUtil.NEWLINE);
        this.appendHeaders(buf);
        buf.setLength(buf.length() - StringUtil.NEWLINE.length());
        return buf.toString();
    }

    protected void appendHeaders(StringBuilder buf) {
        for (Map.Entry<String, String> e : this.getHeaders()) {
            buf.append("    ");
            buf.append(e.getKey());
            buf.append(": ");
            buf.append(e.getValue());
            buf.append(StringUtil.NEWLINE);
        }
    }
}

