/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.netty.handler.codec.spdy;

import com.facebook.presto.jdbc.internal.netty.buffer.ChannelBuffer;
import com.facebook.presto.jdbc.internal.netty.buffer.ChannelBuffers;
import com.facebook.presto.jdbc.internal.netty.handler.codec.spdy.SpdyCodecUtil;
import com.facebook.presto.jdbc.internal.netty.handler.codec.spdy.SpdyHeaderBlockRawEncoder;
import com.facebook.presto.jdbc.internal.netty.handler.codec.spdy.SpdyHeadersFrame;
import java.util.zip.Deflater;

class SpdyHeaderBlockZlibEncoder
extends SpdyHeaderBlockRawEncoder {
    private final byte[] out = new byte[8192];
    private final Deflater compressor;
    private boolean finished;

    public SpdyHeaderBlockZlibEncoder(int version, int compressionLevel) {
        super(version);
        if (compressionLevel < 0 || compressionLevel > 9) {
            throw new IllegalArgumentException("compressionLevel: " + compressionLevel + " (expected: 0-9)");
        }
        this.compressor = new Deflater(compressionLevel);
        if (version < 3) {
            this.compressor.setDictionary(SpdyCodecUtil.SPDY2_DICT);
        } else {
            this.compressor.setDictionary(SpdyCodecUtil.SPDY_DICT);
        }
    }

    private void setInput(ChannelBuffer decompressed) {
        byte[] in = new byte[decompressed.readableBytes()];
        decompressed.readBytes(in);
        this.compressor.setInput(in);
    }

    private void encode(ChannelBuffer compressed) {
        int numBytes = this.out.length;
        while (numBytes == this.out.length) {
            numBytes = this.compressor.deflate(this.out, 0, this.out.length, 2);
            compressed.writeBytes(this.out, 0, numBytes);
        }
    }

    public synchronized ChannelBuffer encode(SpdyHeadersFrame frame) throws Exception {
        if (frame == null) {
            throw new IllegalArgumentException("frame");
        }
        if (this.finished) {
            return ChannelBuffers.EMPTY_BUFFER;
        }
        ChannelBuffer decompressed = super.encode(frame);
        if (decompressed.readableBytes() == 0) {
            return ChannelBuffers.EMPTY_BUFFER;
        }
        ChannelBuffer compressed = ChannelBuffers.dynamicBuffer();
        this.setInput(decompressed);
        this.encode(compressed);
        return compressed;
    }

    public synchronized void end() {
        if (this.finished) {
            return;
        }
        this.finished = true;
        this.compressor.end();
        super.end();
    }
}

