/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.client;

import com.facebook.presto.jdbc.internal.guava.base.Objects;
import com.facebook.presto.jdbc.internal.guava.base.Preconditions;
import java.net.URI;

public class ClientSession {
    private final URI server;
    private final String user;
    private final String source;
    private final String catalog;
    private final String schema;
    private final boolean debug;

    public static ClientSession withCatalog(ClientSession session, String catalog) {
        return new ClientSession(session.getServer(), session.getUser(), session.getSource(), catalog, session.getSchema(), session.isDebug());
    }

    public static ClientSession withSchema(ClientSession session, String schema) {
        return new ClientSession(session.getServer(), session.getUser(), session.getSource(), session.getCatalog(), schema, session.isDebug());
    }

    public ClientSession(URI server, String user, String source, String catalog, String schema, boolean debug) {
        this.server = Preconditions.checkNotNull(server, "server is null");
        this.user = user;
        this.source = source;
        this.catalog = catalog;
        this.schema = schema;
        this.debug = debug;
    }

    public URI getServer() {
        return this.server;
    }

    public String getUser() {
        return this.user;
    }

    public String getSource() {
        return this.source;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public String toString() {
        return Objects.toStringHelper(this).add("server", this.server).add("user", this.user).add("catalog", this.catalog).add("schema", this.schema).add("debug", this.debug).toString();
    }
}

