/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jetty.client.http;

import com.facebook.presto.jdbc.internal.jetty.client.HttpClient;
import com.facebook.presto.jdbc.internal.jetty.client.HttpExchange;
import com.facebook.presto.jdbc.internal.jetty.client.HttpReceiver;
import com.facebook.presto.jdbc.internal.jetty.client.HttpResponse;
import com.facebook.presto.jdbc.internal.jetty.client.HttpResponseException;
import com.facebook.presto.jdbc.internal.jetty.client.http.HttpChannelOverHTTP;
import com.facebook.presto.jdbc.internal.jetty.client.http.HttpConnectionOverHTTP;
import com.facebook.presto.jdbc.internal.jetty.http.HttpField;
import com.facebook.presto.jdbc.internal.jetty.http.HttpMethod;
import com.facebook.presto.jdbc.internal.jetty.http.HttpParser;
import com.facebook.presto.jdbc.internal.jetty.http.HttpVersion;
import com.facebook.presto.jdbc.internal.jetty.io.ByteBufferPool;
import com.facebook.presto.jdbc.internal.jetty.io.EndPoint;
import com.facebook.presto.jdbc.internal.jetty.io.EofException;
import com.facebook.presto.jdbc.internal.jetty.util.BufferUtil;
import java.io.EOFException;
import java.nio.ByteBuffer;

public class HttpReceiverOverHTTP
extends HttpReceiver
implements HttpParser.ResponseHandler<ByteBuffer> {
    private final HttpParser parser = new HttpParser(this);

    public HttpReceiverOverHTTP(HttpChannelOverHTTP channel) {
        super(channel);
    }

    @Override
    public HttpChannelOverHTTP getHttpChannel() {
        return (HttpChannelOverHTTP)super.getHttpChannel();
    }

    private HttpConnectionOverHTTP getHttpConnection() {
        return this.getHttpChannel().getHttpConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive() {
        block12: {
            HttpConnectionOverHTTP connection = this.getHttpConnection();
            EndPoint endPoint = connection.getEndPoint();
            HttpClient client = this.getHttpDestination().getHttpClient();
            ByteBufferPool bufferPool = client.getByteBufferPool();
            ByteBuffer buffer = bufferPool.acquire(client.getResponseBufferSize(), true);
            try {
                int read;
                while (true) {
                    if (connection.isClosed()) {
                        LOG.debug("{} closed", connection);
                        break block12;
                    }
                    read = endPoint.fill(buffer);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Read {} bytes from {}", read, endPoint);
                    }
                    if (read <= 0) break;
                    this.parse(buffer);
                }
                if (read == 0) {
                    this.fillInterested();
                } else {
                    this.shutdown();
                }
            }
            catch (EofException x) {
                LOG.ignore(x);
                this.failAndClose(x);
            }
            catch (Exception x) {
                LOG.debug(x);
                this.failAndClose(x);
            }
            finally {
                bufferPool.release(buffer);
            }
        }
    }

    private void parse(ByteBuffer buffer) {
        while (buffer.hasRemaining()) {
            this.parser.parseNext(buffer);
        }
    }

    private void fillInterested() {
        this.getHttpChannel().getHttpConnection().fillInterested();
    }

    private void shutdown() {
        this.parser.atEOF();
        this.parser.parseNext(BufferUtil.EMPTY_BUFFER);
        if (!this.responseFailure(new EOFException())) {
            this.getHttpConnection().close();
        }
    }

    @Override
    public int getHeaderCacheSize() {
        return 256;
    }

    @Override
    public boolean startResponse(HttpVersion version, int status, String reason) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return false;
        }
        String method = exchange.getRequest().getMethod();
        this.parser.setHeadResponse(HttpMethod.HEAD.is(method) || HttpMethod.CONNECT.is(method));
        exchange.getResponse().version(version).status(status).reason(reason);
        this.responseBegin(exchange);
        return false;
    }

    @Override
    public boolean parsedHeader(HttpField field) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return false;
        }
        this.responseHeader(exchange, field);
        return false;
    }

    @Override
    public boolean headerComplete() {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return false;
        }
        this.responseHeaders(exchange);
        return false;
    }

    @Override
    public boolean content(ByteBuffer buffer) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return false;
        }
        this.responseContent(exchange, buffer);
        return false;
    }

    @Override
    public boolean messageComplete() {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return false;
        }
        this.responseSuccess(exchange);
        return true;
    }

    @Override
    public void earlyEOF() {
        this.failAndClose(new EOFException());
    }

    @Override
    public void badMessage(int status, String reason) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange != null) {
            HttpResponse response = exchange.getResponse();
            response.status(status).reason(reason);
            this.failAndClose(new HttpResponseException("HTTP protocol violation: bad response", response));
        }
    }

    @Override
    protected void reset() {
        super.reset();
        this.parser.reset();
    }

    @Override
    protected void dispose() {
        super.dispose();
        this.parser.close();
    }

    private void failAndClose(Throwable failure) {
        if (this.responseFailure(failure)) {
            this.getHttpChannel().getHttpConnection().close();
        }
    }

    public String toString() {
        return String.format("%s@%x on %s", this.getClass().getSimpleName(), this.hashCode(), this.getHttpConnection());
    }
}

