/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jetty.client.util;

import com.facebook.presto.jdbc.internal.jetty.client.api.ContentProvider;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class BytesContentProvider
implements ContentProvider {
    private final byte[][] bytes;
    private final long length;

    public BytesContentProvider(byte[] ... bytes) {
        this.bytes = bytes;
        long length = 0L;
        for (byte[] buffer : bytes) {
            length += (long)buffer.length;
        }
        this.length = length;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public Iterator<ByteBuffer> iterator() {
        return new Iterator<ByteBuffer>(){
            private int index;

            @Override
            public boolean hasNext() {
                return this.index < BytesContentProvider.this.bytes.length;
            }

            @Override
            public ByteBuffer next() {
                try {
                    return ByteBuffer.wrap(BytesContentProvider.this.bytes[this.index++]);
                }
                catch (ArrayIndexOutOfBoundsException x) {
                    throw new NoSuchElementException();
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

