/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jetty.client;

import com.facebook.presto.jdbc.internal.jetty.client.AsyncContentProvider;
import com.facebook.presto.jdbc.internal.jetty.client.HttpChannel;
import com.facebook.presto.jdbc.internal.jetty.client.HttpContent;
import com.facebook.presto.jdbc.internal.jetty.client.HttpConversation;
import com.facebook.presto.jdbc.internal.jetty.client.HttpDestination;
import com.facebook.presto.jdbc.internal.jetty.client.HttpExchange;
import com.facebook.presto.jdbc.internal.jetty.client.RequestNotifier;
import com.facebook.presto.jdbc.internal.jetty.client.api.ContentProvider;
import com.facebook.presto.jdbc.internal.jetty.client.api.Request;
import com.facebook.presto.jdbc.internal.jetty.client.api.Result;
import com.facebook.presto.jdbc.internal.jetty.http.HttpHeader;
import com.facebook.presto.jdbc.internal.jetty.http.HttpHeaderValue;
import com.facebook.presto.jdbc.internal.jetty.util.BufferUtil;
import com.facebook.presto.jdbc.internal.jetty.util.Callback;
import com.facebook.presto.jdbc.internal.jetty.util.IteratingCallback;
import com.facebook.presto.jdbc.internal.jetty.util.log.Log;
import com.facebook.presto.jdbc.internal.jetty.util.log.Logger;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicReference;

public abstract class HttpSender
implements AsyncContentProvider.Listener {
    protected static final Logger LOG = Log.getLogger(HttpSender.class);
    private final AtomicReference<RequestState> requestState = new AtomicReference<RequestState>(RequestState.QUEUED);
    private final AtomicReference<SenderState> senderState = new AtomicReference<SenderState>(SenderState.IDLE);
    private final Callback commitCallback = new CommitCallback();
    private final Callback contentCallback = new ContentCallback();
    private final Callback lastCallback = new LastContentCallback();
    private final HttpChannel channel;
    private volatile HttpContent content;

    protected HttpSender(HttpChannel channel) {
        this.channel = channel;
    }

    protected HttpChannel getHttpChannel() {
        return this.channel;
    }

    protected HttpExchange getHttpExchange() {
        return this.channel.getHttpExchange();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void onContent() {
        exchange = this.getHttpExchange();
        if (exchange == null) {
            return;
        }
        block7: while (true) {
            current = this.senderState.get();
            switch (1.$SwitchMap$org$eclipse$jetty$client$HttpSender$SenderState[current.ordinal()]) {
                case 1: {
                    newSenderState = SenderState.SENDING;
                    if (!this.updateSenderState(current, newSenderState)) continue block7;
                    HttpSender.LOG.debug("Deferred content available, {} -> {}", new Object[]{current, newSenderState});
                    content = this.content;
                    if (content.advance()) {
                        this.sendContent(exchange, content, this.contentCallback);
                    } else if (content.isConsumed()) {
                        this.sendContent(exchange, content, this.lastCallback);
                    } else {
                        throw new IllegalStateException();
                    }
                    return;
                }
                case 2: {
                    newSenderState = SenderState.SENDING_WITH_CONTENT;
                    if (!this.updateSenderState(current, newSenderState)) continue block7;
                    HttpSender.LOG.debug("Deferred content available, {} -> {}", new Object[]{current, newSenderState});
                    return;
                }
                case 3: {
                    newSenderState = SenderState.EXPECTING_WITH_CONTENT;
                    if (!this.updateSenderState(current, newSenderState)) continue block7;
                    HttpSender.LOG.debug("Deferred content available, {} -> {}", new Object[]{current, newSenderState});
                    return;
                }
                case 4: {
                    newSenderState = SenderState.PROCEEDING_WITH_CONTENT;
                    if (this.updateSenderState(current, newSenderState)) ** break;
                    continue block7;
                    HttpSender.LOG.debug("Deferred content available, {} -> {}", new Object[]{current, newSenderState});
                    return;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    HttpSender.LOG.debug("Deferred content available, {}", new Object[]{current});
                    return;
                }
            }
            break;
        }
        throw new IllegalStateException(current.toString());
    }

    public void send(HttpExchange exchange) {
        Request request = exchange.getRequest();
        Throwable cause = request.getAbortCause();
        if (cause != null) {
            exchange.abort(cause);
        } else {
            if (!this.queuedToBegin(request)) {
                throw new IllegalStateException();
            }
            ContentProvider contentProvider = request.getContent();
            HttpContent content = this.content = new HttpContent(contentProvider);
            SenderState newSenderState = SenderState.SENDING;
            if (this.expects100Continue(request)) {
                SenderState senderState = newSenderState = content.hasContent() ? SenderState.EXPECTING_WITH_CONTENT : SenderState.EXPECTING;
            }
            if (!this.updateSenderState(SenderState.IDLE, newSenderState)) {
                throw new IllegalStateException();
            }
            if (contentProvider instanceof AsyncContentProvider) {
                ((AsyncContentProvider)contentProvider).setListener(this);
            }
            if (!this.beginToHeaders(request)) {
                return;
            }
            this.sendHeaders(exchange, content, this.commitCallback);
        }
    }

    protected boolean expects100Continue(Request request) {
        return request.getHeaders().contains(HttpHeader.EXPECT, HttpHeaderValue.CONTINUE.asString());
    }

    protected boolean queuedToBegin(Request request) {
        if (!this.updateRequestState(RequestState.QUEUED, RequestState.BEGIN)) {
            return false;
        }
        LOG.debug("Request begin {}", request);
        RequestNotifier notifier = this.getHttpChannel().getHttpDestination().getRequestNotifier();
        notifier.notifyBegin(request);
        return true;
    }

    protected boolean beginToHeaders(Request request) {
        if (!this.updateRequestState(RequestState.BEGIN, RequestState.HEADERS)) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Request headers {}{}{}", request, System.getProperty("line.separator"), request.getHeaders().toString().trim());
        }
        RequestNotifier notifier = this.getHttpChannel().getHttpDestination().getRequestNotifier();
        notifier.notifyHeaders(request);
        return true;
    }

    protected boolean headersToCommit(Request request) {
        if (!this.updateRequestState(RequestState.HEADERS, RequestState.COMMIT)) {
            return false;
        }
        LOG.debug("Request committed {}", request);
        RequestNotifier notifier = this.getHttpChannel().getHttpDestination().getRequestNotifier();
        notifier.notifyCommit(request);
        return true;
    }

    protected boolean someToContent(Request request, ByteBuffer content) {
        RequestState current = this.requestState.get();
        switch (current) {
            case COMMIT: 
            case CONTENT: {
                if (!this.updateRequestState(current, RequestState.CONTENT)) {
                    return false;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Request content {}{}{}", request, System.getProperty("line.separator"), BufferUtil.toDetailString(content));
                }
                RequestNotifier notifier = this.getHttpChannel().getHttpDestination().getRequestNotifier();
                notifier.notifyContent(request, content);
                return true;
            }
            case FAILURE: {
                return false;
            }
        }
        throw new IllegalStateException(current.toString());
    }

    protected boolean someToSuccess(HttpExchange exchange) {
        RequestState current = this.requestState.get();
        switch (current) {
            case COMMIT: 
            case CONTENT: {
                boolean completed = exchange.requestComplete();
                if (!completed) {
                    return false;
                }
                this.reset();
                Result result = exchange.terminateRequest(null);
                Request request = exchange.getRequest();
                LOG.debug("Request success {}", request);
                HttpDestination destination = this.getHttpChannel().getHttpDestination();
                destination.getRequestNotifier().notifySuccess(exchange.getRequest());
                if (result != null) {
                    boolean ordered = destination.getHttpClient().isStrictEventOrdering();
                    if (!ordered) {
                        this.channel.exchangeTerminated(result);
                    }
                    LOG.debug("Request/Response succeded {}", request);
                    HttpConversation conversation = exchange.getConversation();
                    destination.getResponseNotifier().notifyComplete(conversation.getResponseListeners(), result);
                    if (ordered) {
                        this.channel.exchangeTerminated(result);
                    }
                }
                return true;
            }
            case FAILURE: {
                return false;
            }
        }
        throw new IllegalStateException(current.toString());
    }

    protected boolean anyToFailure(Throwable failure) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return false;
        }
        boolean completed = exchange.requestComplete();
        if (!completed) {
            return false;
        }
        RequestState requestState = this.dispose();
        Result result = exchange.terminateRequest(failure);
        Request request = exchange.getRequest();
        LOG.debug("Request failure {} {}", exchange, failure);
        HttpDestination destination = this.getHttpChannel().getHttpDestination();
        destination.getRequestNotifier().notifyFailure(request, failure);
        boolean notCommitted = this.isBeforeCommit(requestState);
        if (result == null && notCommitted && request.getAbortCause() == null && exchange.responseComplete()) {
            result = exchange.terminateResponse(failure);
            LOG.debug("Failed response from request {}", exchange);
        }
        if (result != null) {
            boolean ordered = destination.getHttpClient().isStrictEventOrdering();
            if (!ordered) {
                this.channel.exchangeTerminated(result);
            }
            LOG.debug("Request/Response failed {}", request);
            HttpConversation conversation = exchange.getConversation();
            destination.getResponseNotifier().notifyComplete(conversation.getResponseListeners(), result);
            if (ordered) {
                this.channel.exchangeTerminated(result);
            }
        }
        return true;
    }

    protected abstract void sendHeaders(HttpExchange var1, HttpContent var2, Callback var3);

    protected abstract void sendContent(HttpExchange var1, HttpContent var2, Callback var3);

    protected void reset() {
        this.content.close();
        this.content = null;
        this.requestState.set(RequestState.QUEUED);
        this.senderState.set(SenderState.IDLE);
    }

    protected RequestState dispose() {
        RequestState current;
        while (!this.updateRequestState(current = this.requestState.get(), RequestState.FAILURE)) {
        }
        HttpContent content = this.content;
        if (content != null) {
            content.close();
        }
        return current;
    }

    /*
     * Unable to fully structure code
     */
    public void proceed(HttpExchange exchange, Throwable failure) {
        if (!this.expects100Continue(exchange.getRequest())) {
            return;
        }
        if (failure != null) {
            this.anyToFailure(failure);
            return;
        }
        block5: while (true) {
            current = this.senderState.get();
            switch (1.$SwitchMap$org$eclipse$jetty$client$HttpSender$SenderState[current.ordinal()]) {
                case 3: {
                    if (!this.updateSenderState(current, SenderState.PROCEEDING)) continue block5;
                    HttpSender.LOG.debug("Proceeding while expecting", new Object[0]);
                    return;
                }
                case 6: {
                    if (this.updateSenderState(current, SenderState.PROCEEDING_WITH_CONTENT)) ** break;
                    continue block5;
                    HttpSender.LOG.debug("Proceeding while scheduled", new Object[0]);
                    return;
                }
                case 8: {
                    content = this.content;
                    if (content.advance()) {
                        if (!this.updateSenderState(current, SenderState.SENDING)) {
                            throw new IllegalStateException();
                        }
                        HttpSender.LOG.debug("Proceeding while waiting", new Object[0]);
                        this.sendContent(exchange, content, this.contentCallback);
                        return;
                    }
                    if (!this.updateSenderState(current, SenderState.IDLE)) {
                        throw new IllegalStateException();
                    }
                    HttpSender.LOG.debug("Proceeding deferred", new Object[0]);
                    return;
                }
            }
            break;
        }
        throw new IllegalStateException(current.toString());
    }

    public boolean abort(Throwable failure) {
        RequestState current = this.requestState.get();
        boolean abortable = this.isBeforeCommit(current) || this.isSending(current);
        return abortable && this.anyToFailure(failure);
    }

    protected boolean updateRequestState(RequestState from, RequestState to) {
        boolean updated = this.requestState.compareAndSet(from, to);
        if (!updated) {
            LOG.debug("RequestState update failed: {} -> {}: {}", new Object[]{from, to, this.requestState.get()});
        }
        return updated;
    }

    private boolean updateSenderState(SenderState from, SenderState to) {
        boolean updated = this.senderState.compareAndSet(from, to);
        if (!updated) {
            LOG.debug("SenderState update failed: {} -> {}: {}", new Object[]{from, to, this.senderState.get()});
        }
        return updated;
    }

    private boolean isBeforeCommit(RequestState requestState) {
        switch (requestState) {
            case QUEUED: 
            case BEGIN: 
            case HEADERS: {
                return true;
            }
        }
        return false;
    }

    private boolean isSending(RequestState requestState) {
        switch (requestState) {
            case COMMIT: 
            case CONTENT: {
                return true;
            }
        }
        return false;
    }

    private class LastContentCallback
    implements Callback {
        private LastContentCallback() {
        }

        @Override
        public void succeeded() {
            HttpSender.this.content.succeeded();
            HttpExchange exchange = HttpSender.this.getHttpExchange();
            if (exchange == null) {
                return;
            }
            HttpSender.this.someToSuccess(exchange);
        }

        @Override
        public void failed(Throwable failure) {
            HttpSender.this.content.failed(failure);
            HttpSender.this.anyToFailure(failure);
        }
    }

    private class ContentCallback
    extends IteratingCallback {
        private ContentCallback() {
        }

        @Override
        protected IteratingCallback.Action process() throws Exception {
            HttpExchange exchange = HttpSender.this.getHttpExchange();
            if (exchange == null) {
                return IteratingCallback.Action.IDLE;
            }
            Request request = exchange.getRequest();
            HttpContent content = HttpSender.this.content;
            ByteBuffer contentBuffer = content.getContent();
            if (contentBuffer != null && !HttpSender.this.someToContent(request, contentBuffer)) {
                return IteratingCallback.Action.IDLE;
            }
            block4: while (true) {
                boolean advanced = content.advance();
                boolean consumed = content.isConsumed();
                SenderState current = (SenderState)((Object)HttpSender.this.senderState.get());
                switch (current) {
                    case SENDING: {
                        if (advanced) {
                            HttpSender.this.sendContent(exchange, content, this);
                            return IteratingCallback.Action.SCHEDULED;
                        }
                        if (!consumed) continue block4;
                        HttpSender.this.sendContent(exchange, content, HttpSender.this.lastCallback);
                        return IteratingCallback.Action.IDLE;
                        if (!HttpSender.this.updateSenderState(current, SenderState.IDLE)) continue block4;
                        LOG.debug("Waiting for deferred content for {}", request);
                        return IteratingCallback.Action.IDLE;
                    }
                    case SENDING_WITH_CONTENT: {
                        if (HttpSender.this.updateSenderState(current, SenderState.SENDING)) {
                            LOG.debug("Deferred content available for {}", request);
                            if (advanced) {
                                HttpSender.this.sendContent(exchange, content, this);
                                return IteratingCallback.Action.SCHEDULED;
                            }
                        }
                        throw new IllegalStateException();
                    }
                }
                break;
            }
            throw new IllegalStateException();
        }

        @Override
        public void succeeded() {
            HttpSender.this.content.succeeded();
            super.succeeded();
        }

        @Override
        public void failed(Throwable failure) {
            HttpSender.this.content.failed(failure);
            super.failed(failure);
            HttpSender.this.anyToFailure(failure);
        }

        @Override
        protected void completed() {
        }
    }

    private class CommitCallback
    implements Callback {
        private CommitCallback() {
        }

        @Override
        public void succeeded() {
            try {
                HttpSender.this.content.succeeded();
                this.process();
            }
            catch (Exception x) {
                HttpSender.this.anyToFailure(x);
            }
        }

        @Override
        public void failed(Throwable failure) {
            HttpSender.this.content.failed(failure);
            HttpSender.this.anyToFailure(failure);
        }

        private void process() throws Exception {
            HttpExchange exchange = HttpSender.this.getHttpExchange();
            if (exchange == null) {
                return;
            }
            Request request = exchange.getRequest();
            if (!HttpSender.this.headersToCommit(request)) {
                return;
            }
            HttpContent content = HttpSender.this.content;
            if (content.hasContent()) {
                ByteBuffer contentBuffer = content.getContent();
                if (contentBuffer != null && !HttpSender.this.someToContent(request, contentBuffer)) {
                    return;
                }
                block8: while (true) {
                    SenderState current = (SenderState)((Object)HttpSender.this.senderState.get());
                    switch (current) {
                        case SENDING: {
                            if (content.advance()) {
                                HttpSender.this.sendContent(exchange, content, HttpSender.this.contentCallback);
                                return;
                            }
                            if (content.isConsumed()) {
                                HttpSender.this.sendContent(exchange, content, HttpSender.this.lastCallback);
                                return;
                            }
                            if (!HttpSender.this.updateSenderState(current, SenderState.IDLE)) continue block8;
                            LOG.debug("Waiting for deferred content for {}", request);
                            return;
                        }
                        case SENDING_WITH_CONTENT: {
                            HttpSender.this.updateSenderState(current, SenderState.SENDING);
                            continue block8;
                        }
                        case EXPECTING: {
                            if (!HttpSender.this.updateSenderState(current, SenderState.WAITING)) continue block8;
                            return;
                        }
                        case EXPECTING_WITH_CONTENT: {
                            if (!HttpSender.this.updateSenderState(current, SenderState.WAITING)) continue block8;
                            return;
                        }
                        case PROCEEDING: {
                            if (!HttpSender.this.updateSenderState(current, SenderState.IDLE)) continue block8;
                            return;
                        }
                        case PROCEEDING_WITH_CONTENT: {
                            HttpSender.this.updateSenderState(current, SenderState.SENDING);
                            continue block8;
                        }
                    }
                    break;
                }
                throw new IllegalStateException();
            }
            HttpSender.this.someToSuccess(exchange);
        }
    }

    private static enum SenderState {
        IDLE,
        SENDING,
        SENDING_WITH_CONTENT,
        EXPECTING,
        EXPECTING_WITH_CONTENT,
        WAITING,
        PROCEEDING,
        PROCEEDING_WITH_CONTENT;

    }

    protected static enum RequestState {
        QUEUED,
        BEGIN,
        HEADERS,
        COMMIT,
        CONTENT,
        FAILURE;

    }
}

