/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jetty.client;

import com.facebook.presto.jdbc.internal.jetty.client.HttpClient;
import com.facebook.presto.jdbc.internal.jetty.client.HttpDestination;
import com.facebook.presto.jdbc.internal.jetty.client.Origin;
import com.facebook.presto.jdbc.internal.jetty.client.ProxyConfiguration;
import com.facebook.presto.jdbc.internal.jetty.http.HttpScheme;
import com.facebook.presto.jdbc.internal.jetty.io.AbstractConnection;
import com.facebook.presto.jdbc.internal.jetty.io.ClientConnectionFactory;
import com.facebook.presto.jdbc.internal.jetty.io.Connection;
import com.facebook.presto.jdbc.internal.jetty.io.EndPoint;
import com.facebook.presto.jdbc.internal.jetty.io.ssl.SslClientConnectionFactory;
import com.facebook.presto.jdbc.internal.jetty.util.BufferUtil;
import com.facebook.presto.jdbc.internal.jetty.util.Callback;
import com.facebook.presto.jdbc.internal.jetty.util.Promise;
import com.facebook.presto.jdbc.internal.jetty.util.log.Log;
import com.facebook.presto.jdbc.internal.jetty.util.log.Logger;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Socks4Proxy
extends ProxyConfiguration.Proxy {
    public Socks4Proxy(String host, int port) {
        this(new Origin.Address(host, port), false);
    }

    public Socks4Proxy(Origin.Address address, boolean secure) {
        super(address, secure);
    }

    @Override
    public ClientConnectionFactory newClientConnectionFactory(ClientConnectionFactory connectionFactory) {
        return new Socks4ProxyClientConnectionFactory(connectionFactory);
    }

    private static class Socks4ProxyConnection
    extends AbstractConnection
    implements Callback {
        private static final Pattern IPv4_PATTERN = Pattern.compile("(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})");
        private static final Logger LOG = Log.getLogger(Socks4ProxyConnection.class);
        private final ClientConnectionFactory connectionFactory;
        private final Map<String, Object> context;

        public Socks4ProxyConnection(EndPoint endPoint, Executor executor, ClientConnectionFactory connectionFactory, Map<String, Object> context) {
            super(endPoint, executor);
            this.connectionFactory = connectionFactory;
            this.context = context;
        }

        @Override
        public void onOpen() {
            super.onOpen();
            this.writeSocks4Connect();
        }

        private void writeSocks4Connect() {
            HttpDestination destination = (HttpDestination)this.context.get("http.destination");
            String host = destination.getHost();
            short port = (short)destination.getPort();
            Matcher matcher = IPv4_PATTERN.matcher(host);
            if (matcher.matches()) {
                ByteBuffer buffer = ByteBuffer.allocate(9);
                buffer.put((byte)4).put((byte)1).putShort(port);
                for (int i = 1; i <= 4; ++i) {
                    buffer.put((byte)Integer.parseInt(matcher.group(i)));
                }
                buffer.put((byte)0);
                buffer.flip();
                this.getEndPoint().write(this, buffer);
            } else {
                byte[] hostBytes = host.getBytes(StandardCharsets.UTF_8);
                ByteBuffer buffer = ByteBuffer.allocate(9 + hostBytes.length + 1);
                buffer.put((byte)4).put((byte)1).putShort(port);
                buffer.put((byte)0).put((byte)0).put((byte)0).put((byte)1).put((byte)0);
                buffer.put(hostBytes).put((byte)0);
                buffer.flip();
                this.getEndPoint().write(this, buffer);
            }
        }

        @Override
        public void succeeded() {
            LOG.debug("Written SOCKS4 connect request", new Object[0]);
            this.fillInterested();
        }

        @Override
        public void failed(Throwable x) {
            this.close();
            Promise promise = (Promise)this.context.get("http.connection.promise");
            promise.failed(x);
        }

        @Override
        public void onFillable() {
            try {
                ByteBuffer buffer = BufferUtil.allocate(8);
                int filled = this.getEndPoint().fill(buffer);
                LOG.debug("Read SOCKS4 connect response, {} bytes", filled);
                if (filled != 8) {
                    throw new IOException("Invalid response from SOCKS4 proxy");
                }
                byte result = buffer.get(1);
                if (result != 90) {
                    throw new IOException("SOCKS4 tunnel failed with code " + result);
                }
                this.tunnel();
            }
            catch (Throwable x) {
                this.failed(x);
            }
        }

        private void tunnel() {
            try {
                HttpDestination destination = (HttpDestination)this.context.get("http.destination");
                HttpClient client = destination.getHttpClient();
                ClientConnectionFactory connectionFactory = this.connectionFactory;
                if (HttpScheme.HTTPS.is(destination.getScheme())) {
                    connectionFactory = new SslClientConnectionFactory(client.getSslContextFactory(), client.getByteBufferPool(), client.getExecutor(), connectionFactory);
                }
                Connection connection = connectionFactory.newConnection(this.getEndPoint(), this.context);
                ClientConnectionFactory.Helper.replaceConnection(this, connection);
                LOG.debug("SOCKS4 tunnel established: {} over {}", this, connection);
            }
            catch (Throwable x) {
                this.failed(x);
            }
        }
    }

    public static class Socks4ProxyClientConnectionFactory
    implements ClientConnectionFactory {
        private final ClientConnectionFactory connectionFactory;

        public Socks4ProxyClientConnectionFactory(ClientConnectionFactory connectionFactory) {
            this.connectionFactory = connectionFactory;
        }

        @Override
        public Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
            HttpDestination destination = (HttpDestination)context.get("http.destination");
            Executor executor = destination.getHttpClient().getExecutor();
            return new Socks4ProxyConnection(endPoint, executor, this.connectionFactory, context);
        }
    }
}

