/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jetty.io;

import com.facebook.presto.jdbc.internal.jetty.io.Connection;
import com.facebook.presto.jdbc.internal.jetty.io.EndPoint;
import com.facebook.presto.jdbc.internal.jetty.io.FillInterest;
import com.facebook.presto.jdbc.internal.jetty.io.IdleTimeout;
import com.facebook.presto.jdbc.internal.jetty.io.WriteFlusher;
import com.facebook.presto.jdbc.internal.jetty.util.Callback;
import com.facebook.presto.jdbc.internal.jetty.util.log.Log;
import com.facebook.presto.jdbc.internal.jetty.util.log.Logger;
import com.facebook.presto.jdbc.internal.jetty.util.thread.Scheduler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeoutException;

public abstract class AbstractEndPoint
extends IdleTimeout
implements EndPoint {
    private static final Logger LOG = Log.getLogger(AbstractEndPoint.class);
    private final long _created = System.currentTimeMillis();
    private final InetSocketAddress _local;
    private final InetSocketAddress _remote;
    private volatile Connection _connection;
    private final FillInterest _fillInterest = new FillInterest(){

        @Override
        protected boolean needsFill() throws IOException {
            return AbstractEndPoint.this.needsFill();
        }
    };
    private final WriteFlusher _writeFlusher = new WriteFlusher(this){

        @Override
        protected void onIncompleteFlushed() {
            AbstractEndPoint.this.onIncompleteFlush();
        }
    };

    protected AbstractEndPoint(Scheduler scheduler, InetSocketAddress local, InetSocketAddress remote) {
        super(scheduler);
        this._local = local;
        this._remote = remote;
    }

    @Override
    public long getCreatedTimeStamp() {
        return this._created;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this._local;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this._remote;
    }

    @Override
    public Connection getConnection() {
        return this._connection;
    }

    @Override
    public void setConnection(Connection connection) {
        this._connection = connection;
    }

    @Override
    public void onOpen() {
        LOG.debug("onOpen {}", this);
        super.onOpen();
    }

    @Override
    public void onClose() {
        super.onClose();
        LOG.debug("onClose {}", this);
        this._writeFlusher.onClose();
        this._fillInterest.onClose();
    }

    @Override
    public void close() {
        this.onClose();
    }

    @Override
    public void fillInterested(Callback callback) throws IllegalStateException {
        this.notIdle();
        this._fillInterest.register(callback);
    }

    @Override
    public void write(Callback callback, ByteBuffer ... buffers) throws IllegalStateException {
        this._writeFlusher.write(callback, buffers);
    }

    protected abstract void onIncompleteFlush();

    protected abstract boolean needsFill() throws IOException;

    protected FillInterest getFillInterest() {
        return this._fillInterest;
    }

    protected WriteFlusher getWriteFlusher() {
        return this._writeFlusher;
    }

    @Override
    protected void onIdleExpired(TimeoutException timeout) {
        boolean output_shutdown = this.isOutputShutdown();
        boolean input_shutdown = this.isInputShutdown();
        this._fillInterest.onFail(timeout);
        this._writeFlusher.onFail(timeout);
        if (this.isOpen() && output_shutdown || input_shutdown) {
            this.close();
        }
    }

    public String toString() {
        return String.format("%s@%x{%s<->%d,%s,%s,%s,%s,%s,%d,%s}", this.getClass().getSimpleName(), this.hashCode(), this.getRemoteAddress(), this.getLocalAddress().getPort(), this.isOpen() ? "Open" : "CLOSED", this.isInputShutdown() ? "ISHUT" : "in", this.isOutputShutdown() ? "OSHUT" : "out", this._fillInterest.isInterested() ? "R" : "-", this._writeFlusher.isInProgress() ? "W" : "-", this.getIdleTimeout(), this.getConnection() == null ? null : this.getConnection().getClass().getSimpleName());
    }
}

