/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc;

import com.facebook.presto.jdbc.internal.guava.base.Preconditions;

class ColumnInfo {
    private final int columnType;
    private final String columnTypeName;
    private final int nullable;
    private final boolean currency;
    private final boolean signed;
    private final int precision;
    private final int scale;
    private final int columnDisplaySize;
    private final String columnLabel;
    private final String columnName;
    private final String tableName;
    private final String schemaName;
    private final String catalogName;

    public ColumnInfo(int columnType, String columnTypeName, int nullable, boolean currency, boolean signed, int precision, int scale, int columnDisplaySize, String columnLabel, String columnName, String tableName, String schemaName, String catalogName) {
        this.columnType = columnType;
        this.columnTypeName = Preconditions.checkNotNull(columnTypeName, "columnTypeName is null");
        this.nullable = nullable;
        this.currency = currency;
        this.signed = signed;
        this.precision = precision;
        this.scale = scale;
        this.columnDisplaySize = columnDisplaySize;
        this.columnLabel = Preconditions.checkNotNull(columnLabel, "columnLabel is null");
        this.columnName = Preconditions.checkNotNull(columnName, "columnName is null");
        this.tableName = Preconditions.checkNotNull(tableName, "tableName is null");
        this.schemaName = Preconditions.checkNotNull(schemaName, "schemaName is null");
        this.catalogName = Preconditions.checkNotNull(catalogName, "catalogName is null");
    }

    public int getColumnType() {
        return this.columnType;
    }

    public String getColumnTypeName() {
        return this.columnTypeName;
    }

    public int getNullable() {
        return this.nullable;
    }

    public boolean isCurrency() {
        return this.currency;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public int getColumnDisplaySize() {
        return this.columnDisplaySize;
    }

    public String getColumnLabel() {
        return this.columnLabel;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    static class Builder {
        private int columnType;
        private String columnTypeName;
        private int nullable;
        private boolean currency;
        private boolean signed;
        private int precision;
        private int scale;
        private int columnDisplaySize;
        private String columnLabel;
        private String columnName;
        private String tableName;
        private String schemaName;
        private String catalogName;

        Builder() {
        }

        public Builder setColumnType(int columnType) {
            this.columnType = columnType;
            return this;
        }

        public Builder setColumnTypeName(String columnTypeName) {
            this.columnTypeName = columnTypeName;
            return this;
        }

        public Builder setNullable(int nullable) {
            this.nullable = nullable;
            return this;
        }

        public Builder setCurrency(boolean currency) {
            this.currency = currency;
            return this;
        }

        public Builder setSigned(boolean signed) {
            this.signed = signed;
            return this;
        }

        public Builder setPrecision(int precision) {
            this.precision = precision;
            return this;
        }

        public Builder setScale(int scale) {
            this.scale = scale;
            return this;
        }

        public Builder setColumnDisplaySize(int columnDisplaySize) {
            this.columnDisplaySize = columnDisplaySize;
            return this;
        }

        public Builder setColumnLabel(String columnLabel) {
            this.columnLabel = columnLabel;
            return this;
        }

        public Builder setColumnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public Builder setTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder setSchemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public Builder setCatalogName(String catalogName) {
            this.catalogName = catalogName;
            return this;
        }

        public ColumnInfo build() {
            return new ColumnInfo(this.columnType, this.columnTypeName, this.nullable, this.currency, this.signed, this.precision, this.scale, this.columnDisplaySize, this.columnLabel, this.columnName, this.tableName, this.schemaName, this.catalogName);
        }
    }
}

