/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jackson.databind.ser.std;

import com.facebook.presto.jdbc.internal.jackson.annotation.JsonFormat;
import com.facebook.presto.jdbc.internal.jackson.core.JsonGenerationException;
import com.facebook.presto.jdbc.internal.jackson.core.JsonGenerator;
import com.facebook.presto.jdbc.internal.jackson.databind.BeanProperty;
import com.facebook.presto.jdbc.internal.jackson.databind.JavaType;
import com.facebook.presto.jdbc.internal.jackson.databind.JsonMappingException;
import com.facebook.presto.jdbc.internal.jackson.databind.JsonNode;
import com.facebook.presto.jdbc.internal.jackson.databind.JsonSerializer;
import com.facebook.presto.jdbc.internal.jackson.databind.SerializationFeature;
import com.facebook.presto.jdbc.internal.jackson.databind.SerializerProvider;
import com.facebook.presto.jdbc.internal.jackson.databind.introspect.Annotated;
import com.facebook.presto.jdbc.internal.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.facebook.presto.jdbc.internal.jackson.databind.jsonFormatVisitors.JsonValueFormat;
import com.facebook.presto.jdbc.internal.jackson.databind.ser.ContextualSerializer;
import com.facebook.presto.jdbc.internal.jackson.databind.ser.std.StdScalarSerializer;
import com.facebook.presto.jdbc.internal.jackson.databind.util.StdDateFormat;
import java.io.IOException;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DateTimeSerializerBase<T>
extends StdScalarSerializer<T>
implements ContextualSerializer {
    protected final boolean _useTimestamp;
    protected final DateFormat _customFormat;

    protected DateTimeSerializerBase(Class<T> type, boolean useTimestamp, DateFormat customFormat) {
        super(type);
        this._useTimestamp = useTimestamp;
        this._customFormat = customFormat;
    }

    public abstract DateTimeSerializerBase<T> withFormat(boolean var1, DateFormat var2);

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        JsonFormat.Value format;
        if (property != null && (format = prov.getAnnotationIntrospector().findFormat((Annotated)property.getMember())) != null) {
            if (format.getShape().isNumeric()) {
                return this.withFormat(true, null);
            }
            TimeZone tz = format.getTimeZone();
            String pattern = format.getPattern();
            if (pattern.length() > 0) {
                Locale loc = format.getLocale();
                if (loc == null) {
                    loc = prov.getLocale();
                }
                SimpleDateFormat df = new SimpleDateFormat(pattern, loc);
                if (tz == null) {
                    tz = prov.getTimeZone();
                }
                df.setTimeZone(tz);
                return this.withFormat(false, df);
            }
            if (tz != null) {
                DateFormat df = prov.getConfig().getDateFormat();
                if (df.getClass() == StdDateFormat.class) {
                    df = StdDateFormat.getISO8601Format(tz);
                } else {
                    df = (DateFormat)df.clone();
                    df.setTimeZone(tz);
                }
                return this.withFormat(false, df);
            }
        }
        return this;
    }

    @Override
    public boolean isEmpty(T value) {
        return value == null || this._timestamp(value) == 0L;
    }

    protected abstract long _timestamp(T var1);

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        boolean asNumber = this._useTimestamp;
        if (!asNumber && this._customFormat == null) {
            asNumber = provider.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        }
        return this.createSchemaNode(asNumber ? "number" : "string", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) {
        boolean asNumber = this._useTimestamp;
        if (!asNumber && this._customFormat == null) {
            asNumber = visitor.getProvider().isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        }
        if (asNumber) {
            visitor.expectNumberFormat(typeHint).format(JsonValueFormat.UTC_MILLISEC);
        } else {
            visitor.expectStringFormat(typeHint).format(JsonValueFormat.DATE_TIME);
        }
    }

    @Override
    public abstract void serialize(T var1, JsonGenerator var2, SerializerProvider var3) throws IOException, JsonGenerationException;
}

