/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jackson.datatype.guava.deser;

import com.facebook.presto.jdbc.internal.guava.base.Optional;
import com.facebook.presto.jdbc.internal.jackson.core.JsonParser;
import com.facebook.presto.jdbc.internal.jackson.core.JsonProcessingException;
import com.facebook.presto.jdbc.internal.jackson.databind.DeserializationContext;
import com.facebook.presto.jdbc.internal.jackson.databind.JavaType;
import com.facebook.presto.jdbc.internal.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;

public final class GuavaOptionalDeserializer
extends StdDeserializer<Optional<?>> {
    private final JavaType _referenceType;

    public GuavaOptionalDeserializer(JavaType valueType) {
        super(valueType);
        this._referenceType = valueType.containedType(0);
    }

    @Override
    public Optional<?> getNullValue() {
        return Optional.absent();
    }

    @Override
    public Optional<?> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Object reference = ctxt.findRootValueDeserializer(this._referenceType).deserialize(jp, ctxt);
        return Optional.of(reference);
    }
}

