package com.facebook.presto.jdbc.internal.jackson.datatype.joda.ser;

import java.io.IOException;

import com.facebook.presto.jdbc.internal.joda.time.Duration;

import com.facebook.presto.jdbc.internal.jackson.core.JsonGenerator;
import com.facebook.presto.jdbc.internal.jackson.core.JsonProcessingException;
import com.facebook.presto.jdbc.internal.jackson.databind.SerializerProvider;
import com.facebook.presto.jdbc.internal.jackson.databind.ser.std.StdScalarSerializer;

/**
 * Serializes a Duration as its number of millis.
 */
public final class DurationSerializer extends StdScalarSerializer<Duration>
{

    public DurationSerializer() { super(Duration.class); }

    @Override
    public void serialize(Duration value, JsonGenerator jgen, SerializerProvider provider) throws IOException,
        JsonProcessingException
    {
        jgen.writeNumber(value.getMillis());
    }
}
