/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.airlift.http.client.testing;

import com.facebook.presto.jdbc.internal.airlift.http.client.HttpStatus;
import com.facebook.presto.jdbc.internal.airlift.http.client.Response;
import com.facebook.presto.jdbc.internal.guava.base.Charsets;
import com.facebook.presto.jdbc.internal.guava.base.Objects;
import com.facebook.presto.jdbc.internal.guava.base.Preconditions;
import com.facebook.presto.jdbc.internal.guava.collect.ImmutableListMultimap;
import com.facebook.presto.jdbc.internal.guava.collect.ListMultimap;
import com.facebook.presto.jdbc.internal.guava.collect.Multimap;
import com.facebook.presto.jdbc.internal.guava.io.CountingInputStream;
import com.facebook.presto.jdbc.internal.guava.net.MediaType;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class TestingResponse
implements Response {
    private final HttpStatus status;
    private final ListMultimap<String, String> headers;
    private final CountingInputStream countingInputStream;

    public TestingResponse(HttpStatus status, ListMultimap<String, String> headers, byte[] bytes) {
        this(status, headers, new ByteArrayInputStream(Preconditions.checkNotNull(bytes, "bytes is null")));
    }

    public TestingResponse(HttpStatus status, ListMultimap<String, String> headers, InputStream input) {
        this.status = Preconditions.checkNotNull(status, "status is null");
        this.headers = ImmutableListMultimap.copyOf((Multimap)Preconditions.checkNotNull(headers, "headers is null"));
        this.countingInputStream = new CountingInputStream(Preconditions.checkNotNull(input, "input is null"));
    }

    @Override
    public int getStatusCode() {
        return this.status.code();
    }

    @Override
    public String getStatusMessage() {
        return this.status.reason();
    }

    @Override
    public String getHeader(String name) {
        List<String> list = this.getHeaders().get(name);
        return list.isEmpty() ? null : list.get(0);
    }

    @Override
    public ListMultimap<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public long getBytesRead() {
        return this.countingInputStream.getCount();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.countingInputStream;
    }

    public String toString() {
        return Objects.toStringHelper(this).add("statusCode", this.getStatusCode()).add("statusMessage", this.getStatusMessage()).add("headers", this.getHeaders()).toString();
    }

    public static ListMultimap<String, String> contentType(MediaType type) {
        return ImmutableListMultimap.of("Content-Type", type.toString());
    }

    public static Response mockResponse(HttpStatus status, MediaType type, String content) {
        return new TestingResponse(status, TestingResponse.contentType(type), content.getBytes(Charsets.UTF_8));
    }
}

