/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.airlift.http.client;

import com.facebook.presto.jdbc.internal.airlift.http.client.Request;
import com.facebook.presto.jdbc.internal.airlift.http.client.Response;
import com.facebook.presto.jdbc.internal.airlift.http.client.ResponseHandler;
import com.facebook.presto.jdbc.internal.airlift.http.client.ResponseHandlerUtils;
import com.facebook.presto.jdbc.internal.airlift.json.JsonCodec;
import com.facebook.presto.jdbc.internal.guava.base.Objects;
import com.facebook.presto.jdbc.internal.guava.collect.ImmutableListMultimap;
import com.facebook.presto.jdbc.internal.guava.collect.ListMultimap;
import com.facebook.presto.jdbc.internal.guava.io.ByteStreams;
import com.facebook.presto.jdbc.internal.guava.net.MediaType;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class FullJsonResponseHandler<T>
implements ResponseHandler<JsonResponse<T>, RuntimeException> {
    private static final MediaType MEDIA_TYPE_JSON = MediaType.create("application", "json");
    private final JsonCodec<T> jsonCodec;

    public static <T> FullJsonResponseHandler<T> createFullJsonResponseHandler(JsonCodec<T> jsonCodec) {
        return new FullJsonResponseHandler<T>(jsonCodec);
    }

    private FullJsonResponseHandler(JsonCodec<T> jsonCodec) {
        this.jsonCodec = jsonCodec;
    }

    @Override
    public JsonResponse<T> handleException(Request request, Exception exception) {
        throw ResponseHandlerUtils.propagate(request, exception);
    }

    @Override
    public JsonResponse<T> handle(Request request, Response response) {
        String contentType = response.getHeader("Content-Type");
        if (contentType == null || !MediaType.parse(contentType).is(MEDIA_TYPE_JSON)) {
            return new JsonResponse(response.getStatusCode(), response.getStatusMessage(), response.getHeaders());
        }
        try {
            byte[] bytes = ByteStreams.toByteArray(response.getInputStream());
            return new JsonResponse<T>(response.getStatusCode(), response.getStatusMessage(), response.getHeaders(), this.jsonCodec, bytes);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading JSON response from server", e);
        }
    }

    public static class JsonResponse<T> {
        private final int statusCode;
        private final String statusMessage;
        private final ListMultimap<String, String> headers;
        private final boolean hasValue;
        private final byte[] jsonBytes;
        private final T value;
        private final IllegalArgumentException exception;

        public JsonResponse(int statusCode, String statusMessage, ListMultimap<String, String> headers) {
            this.statusCode = statusCode;
            this.statusMessage = statusMessage;
            this.headers = ImmutableListMultimap.copyOf(headers);
            this.hasValue = false;
            this.jsonBytes = null;
            this.value = null;
            this.exception = null;
        }

        public JsonResponse(int statusCode, String statusMessage, ListMultimap<String, String> headers, JsonCodec<T> jsonCodec, byte[] jsonBytes) {
            this.statusCode = statusCode;
            this.statusMessage = statusMessage;
            this.headers = ImmutableListMultimap.copyOf(headers);
            this.jsonBytes = jsonBytes;
            Object value = null;
            IllegalArgumentException exception = null;
            try {
                value = jsonCodec.fromJson(jsonBytes);
            }
            catch (IllegalArgumentException e) {
                exception = new IllegalArgumentException("Unable to create " + jsonCodec.getType() + " from JSON response:\n" + this.getJson(), e);
            }
            this.hasValue = exception == null;
            this.value = value;
            this.exception = exception;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getStatusMessage() {
            return this.statusMessage;
        }

        public String getHeader(String name) {
            List<String> values = this.getHeaders().get(name);
            if (values.isEmpty()) {
                return null;
            }
            return values.get(0);
        }

        public ListMultimap<String, String> getHeaders() {
            return this.headers;
        }

        public boolean hasValue() {
            return this.hasValue;
        }

        public T getValue() {
            if (!this.hasValue) {
                throw new IllegalStateException("Response does not contain a JSON value", this.exception);
            }
            return this.value;
        }

        public byte[] getJsonBytes() {
            return this.jsonBytes == null ? null : (byte[])this.jsonBytes.clone();
        }

        public String getJson() {
            return this.jsonBytes == null ? null : new String(this.jsonBytes, StandardCharsets.UTF_8);
        }

        public IllegalArgumentException getException() {
            return this.exception;
        }

        public String toString() {
            return Objects.toStringHelper(this).add("statusCode", this.statusCode).add("statusMessage", this.statusMessage).add("headers", this.headers).add("hasValue", this.hasValue).add("value", this.value).toString();
        }
    }
}

