/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jetty.util.thread;

import com.facebook.presto.jdbc.internal.jetty.util.component.AbstractLifeCycle;
import com.facebook.presto.jdbc.internal.jetty.util.thread.Scheduler;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class ScheduledExecutorScheduler
extends AbstractLifeCycle
implements Scheduler {
    private final String name;
    private final boolean daemon;
    private volatile ScheduledThreadPoolExecutor scheduler;

    public ScheduledExecutorScheduler() {
        this(null, false);
    }

    public ScheduledExecutorScheduler(String name, boolean daemon) {
        this.name = name == null ? "Scheduler-" + this.hashCode() : name;
        this.daemon = daemon;
    }

    @Override
    protected void doStart() throws Exception {
        this.scheduler = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, ScheduledExecutorScheduler.this.name);
                thread.setDaemon(ScheduledExecutorScheduler.this.daemon);
                return thread;
            }
        });
        this.scheduler.setRemoveOnCancelPolicy(true);
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        this.scheduler.shutdownNow();
        super.doStop();
        this.scheduler = null;
    }

    @Override
    public Scheduler.Task schedule(Runnable task, long delay, TimeUnit unit) {
        ScheduledFuture<?> result = this.scheduler.schedule(task, delay, unit);
        return new ScheduledFutureTask(result);
    }

    private class ScheduledFutureTask
    implements Scheduler.Task {
        private final ScheduledFuture<?> scheduledFuture;

        public ScheduledFutureTask(ScheduledFuture<?> scheduledFuture) {
            this.scheduledFuture = scheduledFuture;
        }

        @Override
        public boolean cancel() {
            return this.scheduledFuture.cancel(false);
        }
    }
}

