/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.airlift.slice;

import com.facebook.presto.jdbc.internal.airlift.slice.BasicSliceInput;
import com.facebook.presto.jdbc.internal.airlift.slice.BasicSliceOutput;
import com.facebook.presto.jdbc.internal.airlift.slice.JvmUtils;
import com.facebook.presto.jdbc.internal.airlift.slice.Preconditions;
import com.facebook.presto.jdbc.internal.airlift.slice.SliceOutput;
import com.facebook.presto.jdbc.internal.airlift.slice.Slices;
import com.facebook.presto.jdbc.internal.airlift.slice.StringDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import sun.misc.Unsafe;

public final class Slice
implements Comparable<Slice> {
    private final Object base;
    private final long address;
    private final int size;
    private final Object reference;
    private int hash;

    @Deprecated
    public static Slice toUnsafeSlice(ByteBuffer byteBuffer) {
        return Slices.wrappedBuffer(byteBuffer);
    }

    Slice() {
        this.base = null;
        this.address = 0L;
        this.size = 0;
        this.reference = null;
    }

    Slice(byte[] base) {
        Preconditions.checkNotNull(base, "base is null");
        this.base = base;
        this.address = Unsafe.ARRAY_BYTE_BASE_OFFSET;
        this.size = base.length;
        this.reference = null;
    }

    Slice(byte[] base, int offset, int length) {
        Preconditions.checkNotNull(base, "base is null");
        Preconditions.checkPositionIndexes(offset, offset + length, base.length);
        this.base = base;
        this.address = Unsafe.ARRAY_BYTE_BASE_OFFSET + offset;
        this.size = length;
        this.reference = null;
    }

    Slice(@Nullable Object base, long address, int size, @Nullable Object reference) {
        if (address <= 0L) {
            throw new IllegalArgumentException(String.format("Invalid address: %s", address));
        }
        if (size <= 0) {
            throw new IllegalArgumentException(String.format("Invalid size: %s", size));
        }
        Preconditions.checkArgument(address + (long)size >= (long)size, "Address + size is greater than 64 bits");
        this.reference = reference;
        this.base = base;
        this.address = address;
        this.size = size;
    }

    public Object getBase() {
        return this.base;
    }

    public long getAddress() {
        return this.address;
    }

    public int length() {
        return this.size;
    }

    public void fill(byte value) {
        int length;
        int offset = 0;
        long longValue = Slice.fillLong(value);
        for (length = this.size; length >= 8; length -= 8) {
            JvmUtils.unsafe.putLong(this.base, this.address + (long)offset, longValue);
            offset += 8;
        }
        while (length > 0) {
            JvmUtils.unsafe.putByte(this.base, this.address + (long)offset, value);
            ++offset;
            --length;
        }
    }

    public void clear() {
        this.clear(0, this.size);
    }

    public void clear(int offset, int length) {
        while (length >= 8) {
            JvmUtils.unsafe.putLong(this.base, this.address + (long)offset, 0L);
            offset += 8;
            length -= 8;
        }
        while (length > 0) {
            JvmUtils.unsafe.putByte(this.base, this.address + (long)offset, (byte)0);
            ++offset;
            --length;
        }
    }

    public byte getByte(int index) {
        this.checkIndexLength(index, 1);
        return JvmUtils.unsafe.getByte(this.base, this.address + (long)index);
    }

    public short getUnsignedByte(int index) {
        return (short)(this.getByte(index) & 0xFF);
    }

    public short getShort(int index) {
        this.checkIndexLength(index, 2);
        return JvmUtils.unsafe.getShort(this.base, this.address + (long)index);
    }

    public int getInt(int index) {
        this.checkIndexLength(index, 4);
        return JvmUtils.unsafe.getInt(this.base, this.address + (long)index);
    }

    public long getLong(int index) {
        this.checkIndexLength(index, 8);
        return JvmUtils.unsafe.getLong(this.base, this.address + (long)index);
    }

    public float getFloat(int index) {
        this.checkIndexLength(index, 4);
        return JvmUtils.unsafe.getFloat(this.base, this.address + (long)index);
    }

    public double getDouble(int index) {
        this.checkIndexLength(index, 8);
        return JvmUtils.unsafe.getDouble(this.base, this.address + (long)index);
    }

    public void getBytes(int index, Slice destination) {
        this.getBytes(index, destination, 0, destination.length());
    }

    public void getBytes(int index, Slice destination, int destinationIndex, int length) {
        destination.setBytes(destinationIndex, this, index, length);
    }

    public void getBytes(int index, byte[] destination) {
        this.getBytes(index, destination, 0, destination.length);
    }

    public void getBytes(int index, byte[] destination, int destinationIndex, int length) {
        this.checkIndexLength(index, length);
        Preconditions.checkPositionIndexes(destinationIndex, destinationIndex + length, destination.length);
        Slice.copyMemory(this.base, this.address + (long)index, destination, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)destinationIndex, length);
    }

    public byte[] getBytes() {
        return this.getBytes(0, this.length());
    }

    public byte[] getBytes(int index, int length) {
        byte[] bytes = new byte[length];
        this.getBytes(index, bytes, 0, length);
        return bytes;
    }

    public void getBytes(int index, OutputStream out, int length) throws IOException {
        this.checkIndexLength(index, length);
        byte[] buffer = new byte[4096];
        while (length > 0) {
            int size = Math.min(buffer.length, length);
            this.getBytes(index, buffer, 0, size);
            out.write(buffer, 0, size);
            length -= size;
            index += size;
        }
    }

    public void setByte(int index, int value) {
        this.checkIndexLength(index, 1);
        JvmUtils.unsafe.putByte(this.base, this.address + (long)index, (byte)(value & 0xFF));
    }

    public void setShort(int index, int value) {
        this.checkIndexLength(index, 2);
        JvmUtils.unsafe.putShort(this.base, this.address + (long)index, (short)(value & 0xFFFF));
    }

    public void setInt(int index, int value) {
        this.checkIndexLength(index, 4);
        JvmUtils.unsafe.putInt(this.base, this.address + (long)index, value);
    }

    public void setLong(int index, long value) {
        this.checkIndexLength(index, 8);
        JvmUtils.unsafe.putLong(this.base, this.address + (long)index, value);
    }

    public void setFloat(int index, float value) {
        this.checkIndexLength(index, 4);
        JvmUtils.unsafe.putFloat(this.base, this.address + (long)index, value);
    }

    public void setDouble(int index, double value) {
        this.checkIndexLength(index, 8);
        JvmUtils.unsafe.putDouble(this.base, this.address + (long)index, value);
    }

    public void setBytes(int index, Slice source) {
        this.setBytes(index, source, 0, source.length());
    }

    public void setBytes(int index, Slice source, int sourceIndex, int length) {
        this.checkIndexLength(index, length);
        Preconditions.checkPositionIndexes(sourceIndex, sourceIndex + length, source.length());
        Slice.copyMemory(source.base, source.address + (long)sourceIndex, this.base, this.address + (long)index, length);
    }

    public void setBytes(int index, byte[] source) {
        this.setBytes(index, source, 0, source.length);
    }

    public void setBytes(int index, byte[] source, int sourceIndex, int length) {
        Preconditions.checkPositionIndexes(sourceIndex, sourceIndex + length, source.length);
        Slice.copyMemory(source, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)sourceIndex, this.base, this.address + (long)index, length);
    }

    public int setBytes(int index, InputStream in, int length) throws IOException {
        this.checkIndexLength(index, length);
        byte[] bytes = new byte[4096];
        int remaining = length;
        while (remaining > 0) {
            int bytesRead = in.read(bytes, 0, Math.min(bytes.length, remaining));
            if (bytesRead < 0) {
                if (remaining != length) break;
                return -1;
            }
            Slice.copyMemory(bytes, Unsafe.ARRAY_BYTE_BASE_OFFSET, this.base, this.address + (long)index, bytesRead);
            remaining -= bytesRead;
            index += bytesRead;
        }
        return length - remaining;
    }

    public Slice slice(int index, int length) {
        if (index == 0 && length == this.length()) {
            return this;
        }
        this.checkIndexLength(index, length);
        if (length == 0) {
            return Slices.EMPTY_SLICE;
        }
        return new Slice(this.base, this.address + (long)index, length, this.reference);
    }

    @Override
    public int compareTo(Slice that) {
        if (this == that) {
            return 0;
        }
        return this.compareTo(0, this.size, that, 0, that.size);
    }

    public int compareTo(int offset, int length, Slice that, int otherOffset, int otherLength) {
        int compareLength;
        if (this == that && offset == otherOffset && length == otherLength) {
            return 0;
        }
        this.checkIndexLength(offset, length);
        that.checkIndexLength(otherOffset, otherLength);
        for (compareLength = Math.min(length, otherLength); compareLength >= 8; compareLength -= 8) {
            long thisLong = JvmUtils.unsafe.getLong(this.base, this.address + (long)offset);
            thisLong = Long.reverseBytes(thisLong);
            long thatLong = JvmUtils.unsafe.getLong(that.base, that.address + (long)otherOffset);
            int v = Slice.compareUnsignedLongs(thisLong, thatLong = Long.reverseBytes(thatLong));
            if (v != 0) {
                return v;
            }
            offset += 8;
            otherOffset += 8;
        }
        while (compareLength > 0) {
            byte thatByte;
            byte thisByte = JvmUtils.unsafe.getByte(this.base, this.address + (long)offset);
            int v = Slice.compareUnsignedBytes(thisByte, thatByte = JvmUtils.unsafe.getByte(that.base, that.address + (long)otherOffset));
            if (v != 0) {
                return v;
            }
            ++offset;
            ++otherOffset;
            --compareLength;
        }
        return Integer.compare(length, otherLength);
    }

    public boolean equals(Object o) {
        int length;
        if (this == o) {
            return true;
        }
        if (!(o instanceof Slice)) {
            return false;
        }
        Slice that = (Slice)o;
        if (this.length() != that.length()) {
            return false;
        }
        int offset = 0;
        for (length = this.size; length >= 8; length -= 8) {
            long thatLong;
            long thisLong = JvmUtils.unsafe.getLong(this.base, this.address + (long)offset);
            if (thisLong != (thatLong = JvmUtils.unsafe.getLong(that.base, that.address + (long)offset))) {
                return false;
            }
            offset += 8;
        }
        while (length > 0) {
            byte thatByte;
            byte thisByte = JvmUtils.unsafe.getByte(this.base, this.address + (long)offset);
            if (thisByte != (thatByte = JvmUtils.unsafe.getByte(that.base, that.address + (long)offset))) {
                return false;
            }
            ++offset;
            --length;
        }
        return true;
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        this.hash = this.hashCode(0, this.size);
        return this.hash;
    }

    public int hashCode(int offset, int length) {
        int k1;
        this.checkIndexLength(offset, length);
        int seed = 0;
        int c1 = -862048943;
        int c2 = 461845907;
        int len = length;
        int h1 = seed;
        while (length >= 4) {
            k1 = JvmUtils.unsafe.getInt(this.base, this.address + (long)offset);
            k1 *= c1;
            k1 = Integer.rotateLeft(k1, 15);
            h1 ^= (k1 *= c2);
            h1 = Integer.rotateLeft(h1, 13);
            h1 = h1 * 5 + -430675100;
            offset += 4;
            length -= 4;
        }
        k1 = 0;
        switch (length) {
            case 3: {
                k1 ^= Slice.unsignedByteToInt(JvmUtils.unsafe.getByte(this.base, this.address + (long)offset + 2L)) << 16;
            }
            case 2: {
                k1 ^= Slice.unsignedByteToInt(JvmUtils.unsafe.getByte(this.base, this.address + (long)offset + 1L)) << 8;
            }
            case 1: {
                k1 ^= Slice.unsignedByteToInt(JvmUtils.unsafe.getByte(this.base, this.address + (long)offset));
            }
        }
        k1 *= c1;
        k1 = Integer.rotateLeft(k1, 15);
        h1 ^= (k1 *= c2);
        h1 ^= len;
        h1 ^= h1 >>> 16;
        h1 *= -2048144789;
        h1 ^= h1 >>> 13;
        h1 *= -1028477387;
        h1 ^= h1 >>> 16;
        return h1;
    }

    public boolean equals(int offset, int length, Slice that, int otherOffset, int otherLength) {
        if (length != otherLength) {
            return false;
        }
        if (this == that && offset == otherOffset) {
            return true;
        }
        this.checkIndexLength(offset, length);
        that.checkIndexLength(otherOffset, otherLength);
        while (length >= 8) {
            long thatLong;
            long thisLong = JvmUtils.unsafe.getLong(this.base, this.address + (long)offset);
            if (thisLong != (thatLong = JvmUtils.unsafe.getLong(that.base, that.address + (long)otherOffset))) {
                return false;
            }
            offset += 8;
            otherOffset += 8;
            length -= 8;
        }
        while (length > 0) {
            byte thatByte;
            byte thisByte = JvmUtils.unsafe.getByte(this.base, this.address + (long)offset);
            if (thisByte != (thatByte = JvmUtils.unsafe.getByte(that.base, that.address + (long)otherOffset))) {
                return false;
            }
            ++offset;
            ++otherOffset;
            --length;
        }
        return true;
    }

    public BasicSliceInput getInput() {
        return new BasicSliceInput(this);
    }

    public SliceOutput getOutput() {
        return new BasicSliceOutput(this);
    }

    public String toString(Charset charset) {
        return this.toString(0, this.length(), charset);
    }

    public String toStringUtf8() {
        return this.toString(StandardCharsets.UTF_8);
    }

    public String toString(int index, int length, Charset charset) {
        if (length == 0) {
            return "";
        }
        if (this.base instanceof byte[]) {
            return new String((byte[])this.base, (int)(this.address - (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)index), length, charset);
        }
        return StringDecoder.decodeString(this.toByteBuffer(index, length), charset);
    }

    public ByteBuffer toByteBuffer() {
        return this.toByteBuffer(0, this.size);
    }

    public ByteBuffer toByteBuffer(int index, int length) {
        this.checkIndexLength(index, length);
        if (this.base instanceof byte[]) {
            return ByteBuffer.wrap((byte[])this.base, (int)(this.address - (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)index), length);
        }
        try {
            return JvmUtils.newByteBuffer.invokeExact(this.address + (long)index, length, this.reference);
        }
        catch (Throwable throwable) {
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new RuntimeException(throwable);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Slice{");
        if (this.base != null) {
            builder.append("base=").append(Slice.identityToString(this.base)).append(", ");
        }
        builder.append("address=").append(this.address);
        builder.append(", length=").append(this.length());
        builder.append('}');
        return builder.toString();
    }

    private static String identityToString(Object o) {
        if (o == null) {
            return null;
        }
        return o.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(o));
    }

    private static void copyMemory(Object src, long srcAddress, Object dest, long destAddress, int length) {
        int bytesToCopy = length - length % 8;
        JvmUtils.unsafe.copyMemory(src, srcAddress, dest, destAddress, bytesToCopy);
        JvmUtils.unsafe.copyMemory(src, srcAddress + (long)bytesToCopy, dest, destAddress + (long)bytesToCopy, length - bytesToCopy);
    }

    private void checkIndexLength(int index, int length) {
        Preconditions.checkPositionIndexes(index, index + length, this.length());
    }

    private static long fillLong(byte value) {
        return ((long)value & 0xFFL) << 56 | ((long)value & 0xFFL) << 48 | ((long)value & 0xFFL) << 40 | ((long)value & 0xFFL) << 32 | ((long)value & 0xFFL) << 24 | ((long)value & 0xFFL) << 16 | ((long)value & 0xFFL) << 8 | (long)value & 0xFFL;
    }

    private static int compareUnsignedBytes(byte thisByte, byte thatByte) {
        return Slice.unsignedByteToInt(thisByte) - Slice.unsignedByteToInt(thatByte);
    }

    private static int unsignedByteToInt(byte thisByte) {
        return thisByte & 0xFF;
    }

    private static int compareUnsignedLongs(long thisLong, long thatLong) {
        return Long.compare(Slice.flipUnsignedLong(thisLong), Slice.flipUnsignedLong(thatLong));
    }

    private static long flipUnsignedLong(long thisLong) {
        return thisLong ^ Long.MIN_VALUE;
    }
}

