/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jetty.client;

import com.facebook.presto.jdbc.internal.jetty.client.api.ContentResponse;
import com.facebook.presto.jdbc.internal.jetty.client.api.Request;
import com.facebook.presto.jdbc.internal.jetty.client.api.Response;
import com.facebook.presto.jdbc.internal.jetty.client.api.Result;
import com.facebook.presto.jdbc.internal.jetty.http.HttpField;
import com.facebook.presto.jdbc.internal.jetty.util.log.Log;
import com.facebook.presto.jdbc.internal.jetty.util.log.Logger;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;

public class ResponseNotifier {
    private static final Logger LOG = Log.getLogger(ResponseNotifier.class);

    public void notifyBegin(List<Response.ResponseListener> listeners, Response response) {
        for (int i = 0; i < listeners.size(); ++i) {
            Response.ResponseListener listener = listeners.get(i);
            if (!(listener instanceof Response.BeginListener)) continue;
            this.notifyBegin((Response.BeginListener)listener, response);
        }
    }

    private void notifyBegin(Response.BeginListener listener, Response response) {
        try {
            listener.onBegin(response);
        }
        catch (Throwable x) {
            LOG.info("Exception while notifying listener " + listener, x);
        }
    }

    public boolean notifyHeader(List<Response.ResponseListener> listeners, Response response, HttpField field) {
        boolean result = true;
        for (int i = 0; i < listeners.size(); ++i) {
            Response.ResponseListener listener = listeners.get(i);
            if (!(listener instanceof Response.HeaderListener)) continue;
            result &= this.notifyHeader((Response.HeaderListener)listener, response, field);
        }
        return result;
    }

    private boolean notifyHeader(Response.HeaderListener listener, Response response, HttpField field) {
        try {
            return listener.onHeader(response, field);
        }
        catch (Throwable x) {
            LOG.info("Exception while notifying listener " + listener, x);
            return false;
        }
    }

    public void notifyHeaders(List<Response.ResponseListener> listeners, Response response) {
        for (int i = 0; i < listeners.size(); ++i) {
            Response.ResponseListener listener = listeners.get(i);
            if (!(listener instanceof Response.HeadersListener)) continue;
            this.notifyHeaders((Response.HeadersListener)listener, response);
        }
    }

    private void notifyHeaders(Response.HeadersListener listener, Response response) {
        try {
            listener.onHeaders(response);
        }
        catch (Throwable x) {
            LOG.info("Exception while notifying listener " + listener, x);
        }
    }

    public void notifyContent(List<Response.ResponseListener> listeners, Response response, ByteBuffer buffer) {
        if (!(buffer = buffer.slice()).hasRemaining()) {
            return;
        }
        for (int i = 0; i < listeners.size(); ++i) {
            Response.ResponseListener listener = listeners.get(i);
            if (!(listener instanceof Response.ContentListener)) continue;
            buffer.clear();
            this.notifyContent((Response.ContentListener)listener, response, buffer);
        }
    }

    private void notifyContent(Response.ContentListener listener, Response response, ByteBuffer buffer) {
        try {
            listener.onContent(response, buffer);
        }
        catch (Throwable x) {
            LOG.info("Exception while notifying listener " + listener, x);
        }
    }

    public void notifySuccess(List<Response.ResponseListener> listeners, Response response) {
        for (int i = 0; i < listeners.size(); ++i) {
            Response.ResponseListener listener = listeners.get(i);
            if (!(listener instanceof Response.SuccessListener)) continue;
            this.notifySuccess((Response.SuccessListener)listener, response);
        }
    }

    private void notifySuccess(Response.SuccessListener listener, Response response) {
        try {
            listener.onSuccess(response);
        }
        catch (Throwable x) {
            LOG.info("Exception while notifying listener " + listener, x);
        }
    }

    public void notifyFailure(List<Response.ResponseListener> listeners, Response response, Throwable failure) {
        for (int i = 0; i < listeners.size(); ++i) {
            Response.ResponseListener listener = listeners.get(i);
            if (!(listener instanceof Response.FailureListener)) continue;
            this.notifyFailure((Response.FailureListener)listener, response, failure);
        }
    }

    private void notifyFailure(Response.FailureListener listener, Response response, Throwable failure) {
        try {
            listener.onFailure(response, failure);
        }
        catch (Throwable x) {
            LOG.info("Exception while notifying listener " + listener, x);
        }
    }

    public void notifyComplete(List<Response.ResponseListener> listeners, Result result) {
        for (int i = 0; i < listeners.size(); ++i) {
            Response.ResponseListener listener = listeners.get(i);
            if (!(listener instanceof Response.CompleteListener)) continue;
            this.notifyComplete((Response.CompleteListener)listener, result);
        }
    }

    private void notifyComplete(Response.CompleteListener listener, Result result) {
        try {
            listener.onComplete(result);
        }
        catch (Throwable x) {
            LOG.info("Exception while notifying listener " + listener, x);
        }
    }

    public void forwardSuccess(List<Response.ResponseListener> listeners, Response response) {
        this.notifyBegin(listeners, response);
        Iterator<HttpField> iterator = response.getHeaders().iterator();
        while (iterator.hasNext()) {
            HttpField field = iterator.next();
            if (this.notifyHeader(listeners, response, field)) continue;
            iterator.remove();
        }
        this.notifyHeaders(listeners, response);
        if (response instanceof ContentResponse) {
            this.notifyContent(listeners, response, ByteBuffer.wrap(((ContentResponse)response).getContent()));
        }
        this.notifySuccess(listeners, response);
    }

    public void forwardSuccessComplete(List<Response.ResponseListener> listeners, Request request, Response response) {
        this.forwardSuccess(listeners, response);
        this.notifyComplete(listeners, new Result(request, response));
    }

    public void forwardFailure(List<Response.ResponseListener> listeners, Response response, Throwable failure) {
        this.notifyBegin(listeners, response);
        Iterator<HttpField> iterator = response.getHeaders().iterator();
        while (iterator.hasNext()) {
            HttpField field = iterator.next();
            if (this.notifyHeader(listeners, response, field)) continue;
            iterator.remove();
        }
        this.notifyHeaders(listeners, response);
        if (response instanceof ContentResponse) {
            this.notifyContent(listeners, response, ByteBuffer.wrap(((ContentResponse)response).getContent()));
        }
        this.notifyFailure(listeners, response, failure);
    }

    public void forwardFailureComplete(List<Response.ResponseListener> listeners, Request request, Throwable requestFailure, Response response, Throwable responseFailure) {
        this.forwardFailure(listeners, response, responseFailure);
        this.notifyComplete(listeners, new Result(request, requestFailure, response, responseFailure));
    }
}

